/**
 * @author trupti.paoneker
 * 
 * This component is used for to show window with new community master details. 
 */
Ext.define('Academia.view.othermasters.servicemaster.ServiceMappingFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.servicemappingformwindow',
    modal: true,
    resizable: false,
    title: getExaminationTranslation('APPLY_TO'),
    margin: 0,
    items: [{
		xtype: 'form',
		method: 'POST',
		itemId:'serviceMappingForm',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		autoScroll:true,
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			style:{
				marginLeft:'15px'
			},
			defaults :{
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype:'textfield',
				name:'serviceCode',
				itemId:'serviceCodeId',
				readOnly: true,
				fieldLabel: getCommonTranslation('SERVICE_CODE')
			},{
				xtype:'textfield',
				name:'serviceName',
				itemId:'serviceNameId',
				readOnly: true,
				fieldLabel:getCommonTranslation('SERVICE_NAME')
			}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			style:{
				marginLeft:'15px'
			},
			defaults :{
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype:'textfield',
				name:'academyLocationId',
				itemId:'academyLocationId',
				readOnly: true,
				width:462,
				fieldLabel:getProgramandcourseTranslation("ACADEMY_LOCATION")
			}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			style:{
				marginLeft:'15px'
			},
			defaults :{
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype:'textfield',
				name:'program',
				itemId:'program',
				readOnly: true,
				width:462,
				fieldLabel: getCommonTranslation('PROGRAM')
			}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			style:{
				marginLeft:'15px'
			},
			defaults :{
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype:'textfield',
				name:'batch',
				itemId:'batch',
				readOnly: true,
				fieldLabel:getCommonTranslation('BATCH')
			},{
				xtype:'textfield',
				name:'seatType',
				itemId:'seatType',
				readOnly: true,
				fieldLabel:getCommonTranslation('SEAT_TYPE')
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			style:{
				marginLeft:'15px'
			},
			items: [{
	            xtype: 'button',
	            text: getServiceRequestTranslation('CANCEL'),
	            ui: 'CustomBtnCancel',
	            itemId: 'cancelButtonId',
	            scale: CONSTANTS.BUTTONSIZE,
	            handler :function(button) {
	            	button.up('window').close();
	            }
	        }]
		}]
	}]
});