/**
 * @author trupti.paoneker
 * 
 * This component is used for to show window with new service master details. 
 */
Ext.define('Academia.view.othermasters.servicemaster.ServiceMasterFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.servicemasterformwindow',
    modal: true,
    //resizable: false,
    overflowY: 'auto',
	overflowX: 'hidden',
    height : 600,
    title: getCommonTranslation('SERVICE_MASTER_DETAILS'),
    items: [{
        xtype: 'form',
        itemId: 'serviceMasterForm',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'serviceMaster_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'version'
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                fieldLabel: getCommonTranslation('SERVICE_CODE'), //Service Code
                xtype: 'textfield',
                itemId: 'serviceCode',
                name: 'serviceCode',                
                vtype: 'allowSlashAndHyphen',
                labelAlign: 'top',
                maxLength : 20,
                allowBlank: false
            }, {
                fieldLabel: getCommonTranslation('SERVICE_NAME'), //Service Name
                xtype: 'textfield',
                itemId: 'serviceName',
                name: 'serviceName',
                vtype: 'allowSlashAndHyphen',
				maxLength : 100,
                labelAlign: 'top',
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 536
            },
            items: [{
                fieldLabel: getCommonTranslation('SERVICE_DESCRIPTION'), //Service Description
                xtype: 'textarea',
                itemId: 'serviceDescription',
                name: 'serviceDescription',
                labelAlign: 'top',
                allowBlank: false
            }]
        },{
        	xtype:'fieldcontainer',
        	defaults:{
        		labelAlign: 'top',
        		width:235
        	},
        	items:[{
        		xtype:'multiselectcombofield',
        		itemId:'serviceCoordinatorId',
        		name:'serviceCoordinatorName',
        		fieldLabel:getCommonTranslation('SERVICE_COORDINATOR'),
        		displayField:'value',
        		valueField:'id',
        		store:'othermasters.servicemaster.ServiceCoordinatorComboStore',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			minChars:3,
    			queryParam:'qry',
    			typeAhead:true,
        		listConfig: {
        			listeners: {
        				beforeshow: function(picker) {
        					var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
        					//picker.minWidth = picker.up('combobox').getSize().width;
        				}
        			},
        			loadingText: getCommonTranslation('SEARCHING'),
        			emptyText: getCommonTranslation('NO_RECORDS_FOUND')
        		}
        	}]
        },{
            xtype: 'radiogroup',
            labelAlign: 'top',
            fieldLabel: getCommonTranslation('SERVICE_MASTER_BILL'),
            name: 'RADIO_Btn',
            itemId:'billFacultyId',
            layout: {
                type: 'vbox'
            },
            items: [{
                boxLabel: 'Primary academy-location',
                name: 'billFaculty',
                inputValue: true,
                checked: true
            }, {
                boxLabel: 'Academy-Location where service availed',
                name: 'billFaculty',
                width: 536,
                inputValue: false
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'vbox'
            },
            defaults: {
                width: 536
            },
            items: [{
                boxLabel: getCommonTranslation('SERVICE_MASTER_FACILITY'), // Service Facility
                xtype: 'checkboxfield',
                itemId: 'facilityAvailable',
                name: 'facilityAvailable',
                //labelWidth: 400,
                allowBlank: false,
                inputValue: 'true',
                uncheckedValue: 'false',
                boxLabelCls:'clsCheckboxLabel',
                style :{
		        	marginLeft : '5px'
				}
            }, {
                xtype: 'statusCombo',
                itemId: 'active',
                allowBlank: false,
                name: 'active',
                labelAlign: 'top',
                editable: false,
                width: 256
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                itemId: 'btnSaveServiceMasterForm',
                text: getCommonTranslation('SAVE'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelServiceMasterForm',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});