/**
 *  BursaryApplicationDetails Action Grid
 */
Ext.define('Academia.view.personinfo.common.NSFAS.BursaryApplicationDetails', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.bursaryapplicationdetails',
    title: getPersonModuleTranslation('BURSARY_APPLICATION_DETAILS'),
    border: true,
    autoScroll: false,
	scroll: 'vertical',
    isGridConfigurable: true,
    enableColumnHide: false,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'checkStatus',
        text: getCommonTranslation('CHECK_STATUS'),
        tooltip : getCommonTranslation('CHECK_STATUS'),
        ui: 'CustomBtnSubmit',
    }],
    columns: [{
        header: getCommonTranslation('NATIONAL_ID'),
        dataIndex: 'identification',
        sortable: false,
        flex: .2,
        renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return value; 
			}                        
		}
    },  {
        header: getCommonTranslation('STUDENT_NAME'),
        dataIndex: 'name',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('TELEPHONE'),
        dataIndex: 'phoneNumber',
        sortable: false,
        hidden : true,
        flex: .2
    }, {
        header: getCommonTranslation('ADDRESS_LINE'),
        dataIndex: 'addressLine',
        sortable: false,
        hidden : true,
        flex: .2
    }, {
        header: getCommonTranslation('CITY_NAME'),
        dataIndex: 'city',
        sortable: false,
        hidden : true,
        flex: .2
    },{
        header: getCommonTranslation('APPLICATION_DATE'),
        dataIndex: 'applicationDate',
        sortable: false,
        flex: .5,
        renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return dateRender(value)+' '+timeRender(value); 
			}                        
		}
    }, {
        header: getCommonTranslation('CYCLE'),
        dataIndex: 'processCycle',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('LEVEL_OF_STUDY'),
        dataIndex: 'levelOfStudy',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('CAMPUS'),
        dataIndex: 'campus',
        sortable: false,
        flex: .2
		
    }, {
        header: getCommonTranslation('ACCOMODATION'),
        dataIndex: 'accomodation',
        sortable: false,
        flex: .25
    }, {
        header: getCommonTranslation('TRAVEL'),
        dataIndex: 'travel',
        sortable: false,
        flex: .2
    }, {
		header:  getCommonTranslation('MEALS'),
		dataIndex: 'meals',
		sortable:false,
	}, {
        header: getCommonTranslation('CODE'),
        dataIndex: 'progCode',
        sortable: false,
        hidden : true,
        flex: .2
    },{
		header:  getCommonTranslation('NAME'),
		dataIndex: 'progName',
		sortable:false,
	}, {
        header: getCommonTranslation('PREFERRED'),
        dataIndex: 'isPreffered',
        sortable: false,
        hidden : true,
        flex: .2,
        renderer:function(value) {
			if(!isNullOrEmpty(value)) {
				if (value == 'true') {
					return 'True';
				}else{
					return 'False'; 
				}
			}else{
				return '';
			} 
		}
    },{
		header:  getCommonTranslation('STATUS'),
		dataIndex: 'status',
		sortable:false,
	},{
		header: getCommonTranslation('LM_UPDATED_ON'),
		dataIndex: 'lastUpdate',
		sortable:true,
		renderer:function(value) {
			if(!isNullOrEmpty(value)) {
				return dateRender(value)+' '+timeRender(value); 
			}  
		}
	}],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
                       
         //this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.NSFAS.BursaryApplicationDetailStore');
    }

});