/**
 * 
 */
Ext.define('Academia.view.personinfo.common.course.CancelledSessionDetail', {
	extend : 'Ext.form.Panel',
    alias: 'widget.cancelledsessiondetail',
    plugins : "formlabelrequired",
	frame: false,
	method: 'POST',
	autoScroll:false,
	standardSubmit: false,
	cls:'customSearchPanel',
	items: [{
		xtype : 'fieldcontainer',
		itemId:'programBatch_Id',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('PROGRAM'),
			name : 'programId',
			itemId : 'programBatch_programId',
	        store : Ext.create('Academia.store.common.CancelledSessionStore'),
           displayField:'valueCode',
			valueField:'id',
			typeAhead:true,
			allowBlank:true,
			forceSelection:true,
			editable:false
		}, {
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'programBatch_batchId',
			fieldLabel : getCourseTxCommonTranslation('BATCH'),
			disabled:true,
			store: Ext.create('Academia.store.program.programbatchdetail.BatchDropdownStore'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			allowBlank:true,
			forceSelection:true,
			editable:false
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'periodIdItemId',
			fieldLabel: getExaminationTranslation('PERIOD'),
	    	store: Ext.create('Academia.store.common.FindPeriodbyByIdForCancelledStore'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			allowBlank:true,
			typeAhead:true,
			disabled:true,
			editable:false
		}]
	},{
		xtype : 'fieldcontainer',
		
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
				xtype: 'multiselectcombofield',
				name: 'courseId',
				itemId: 'courseId',
				autoloadStore: false,
				width : 300,
				fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
				store:Ext.create('Academia.store.common.CancelledSessionStoreCourse'),
				displayField : 'value',
				valueField : 'id',
				queryParam:'name',
				minChars:3,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				queryMode:'remote',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				allowBlank:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
							
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}

			},{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('START_DATE'),
				name : 'consolidateStartDate',
				itemId:'consolidateStartDate',
				endDateField : 'consolidateEndDate',
				format : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange',
				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}
			},{
				xtype : 'datefield',
				fieldLabel :getProgramandcourseTranslation('END_DATE'),
				name : 'consolidateEndDate',
				itemId : 'consolidateEndDate',
				startDateField : 'consolidateStartDate',
				format : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange',
				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}
			}]
	}
,
	{
		xtype: 'fieldcontainer',
		width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE	        				
		}]
	}]
	
});