/**
 * This form is used for  faculty attendance details
 * @author pravin.surve
 */
Ext.define('Academia.view.personinfo.common.course.FacultyAttendanceQuickSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.facultyattendancequicksearchform',
    frame: false,
    plugins: "formlabelrequired",
    cls:'customSearchPanel',
    items: [{
    	xtype: 'hidden',
    	itemId: 'facultyAttendance_hidden_type',
    	name: 'facultyAttendanceType'
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        itemId: 'programBatchPeriodContainer',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'programId',
            itemId: 'attendanceProgram',
            fieldLabel: getPersonModuleTranslation('ATTENDANCE_PROGRAM'),
            editable: false,
            allowBlank: false,
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
                    combo.bindStore(store);
                }
            }
        },{
        	xtype: 'customcombobox',
            name: 'batch',
            itemId: 'batch',
            fieldLabel: getPersonModuleTranslation('BATCH'),
            editable: false,
            queryMode: 'local',
            valueField: 'id',
            displayField: 'value',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }
            
        },{
        	xtype: 'customcombobox',
            name: 'period',
            itemId: 'period',
            fieldLabel: getPersonModuleTranslation('ATTENDANCE_PERIOD'),
            editable: false,
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.PeriodSection');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        itemId: 'sectionCourseContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'section',
            itemId: 'section',
            fieldLabel: getPersonModuleTranslation('SECTION'),
            editable: false,
            valueField: 'sectionId',
            displayField: 'sectionCode',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
                    combo.bindStore(store);
                }
            }
        },{
            xtype: 'customcombobox',
            name: 'course',
            itemId: 'course',
            fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
            editable: false,
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.coursetransaction.coursereading.CourseByPeriod');
                    combo.bindStore(store);
                }
            }
        },{
            xtype: 'customcombobox',
            name: 'courseComponent',
            itemId: 'courseComponent',
            fieldLabel: getPersonModuleTranslation('ATTENDANCE_COURSE_COMPONENT'),
            editable: false,
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.course.coursetopic.CourseComponentStore');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'datefield',
            name: 'fromDate',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
            fieldLabel: getPersonModuleTranslation('ATTENDANCE_FROMDATE'),
            itemId: 'fromDate',
            //Select from time
            vtype: 'daterange',
            endDateField: 'toDate'
            //emptyText: getPersonModuleTranslation('ATTENDANCE_FROMDATE')
        }, {
            xtype: 'datefield',
            name: 'toDate',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
            fieldLabel: getPersonModuleTranslation('ATTENDANCE_TODATE'),
            itemId: 'toDate',
            //Select from time
           vtype: 'daterange',
           startDateField: 'fromDate'
            //emptyText: getPersonModuleTranslation('ATTENDANCE_TODATE')
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'attendanceSearchButtonId',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getCompletionModuleTranslation('CLEAR_SEARCH'),
            itemId: 'clearSearch',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            listeners: {
                click: function(button, eOpts) {
                	this.up('form').getForm().reset();
                }
            }
        }]
    }]
});