Ext.define('Academia.view.personinfo.common.course.ProgramCourseFacultySearchWindow', {
	extend: 'Ext.form.Panel',
	alias: 'widget.programcoursefacultysearchwindow',
	frame: false,
	autoScroll: true,
	plugins : "formlabelrequired",
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype : 'customcombobox',
			name : 'academicTerm',
			itemId : 'academicTerm',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			store : 'common.AcademicTermStore',
			valueField : 'id',
			displayField : 'value'
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
			name : 'courseVariant',
			itemId : 'courseVariantId',
			store:Ext.create('Academia.store.course.coursevariants.ParameterCourseVariantStore'),
			displayField: 'courseVariantCode',
			valueField: 'id',
			typeAhead : true,
			forceSelection : true
		},{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programItemId',
			store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			width: 256,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {value}'+
	                    '</div>';
	                }
	            }
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [,{
			xtype: 'customcombobox',
			name:'batchId',
			itemId:'batchItemId',
			store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			disabled:true,
			typeAhead : true,
			forceSelection : true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			disabled:true,
			store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			typeAhead : true,
			forceSelection : true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'sectionId',
			itemId: 'sectionItemId',
			disabled:true,
			store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			fieldLabel:getExaminationTranslation('SECTION'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			typeAhead : true,
			forceSelection : true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype: 'customcombobox',
			name: 'alternateFaculty',
			itemId:'alternateFaculty',
			fieldLabel: getPersonModuleTranslation('ALTERNATE_FACULTY'),
			store: 'coursetransaction.facultytopicassignment.AlternateFacultyStore',
			valueField : 'id',
			displayField : 'value',
			editable: false
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			formBind: true,
			itemId: 'searchButtonId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCompletionModuleTranslation('CLEAR_SEARCH'),
			itemId: 'clearSearch',
			buttonAlign: 'right',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			listeners: {
				click: function(button, eOpts) {
					this.up('form').getForm().reset();
				}
			}
		}]
	}]
});