/**
 * This form panel is used for My Course details Learning Targets
 * @author  Amit G
 */
Ext.define('Academia.view.personinfo.common.course.VWMyCourseDetailsLearningTargets', {
	extend: 'Ext.form.Panel',
	alias: 'widget.vwmycoursedetailslearningtargets',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	items: [{
		xtype:'fieldcontainer',
		width:'auto',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
		xtype : 'datefield',
		fieldLabel : getExaminationTranslation('REVIEW_DATE'),
		name : 'stuLearningReviewDate',
		itemId:'stuLearningReviewDateItemId',
		endDateField : 'stuLearningNextReviewDateItemId',
		vtype : 'daterange',
		maxValue:new Date(),
		listeners: {
			render: function(obj) {
				obj = dateFormatRender(obj);						
				obj.setValue(new Date());
			}
		}
	},{
		xtype : 'datefield',
		fieldLabel : getExaminationTranslation('NEXT_REVIEW_DATE'),
		name : 'stuLearningNextReviewDate',
		itemId:'stuLearningNextReviewDateItemId',
		startDateField : 'stuLearningReviewDateItemId',
		vtype : 'daterange',
		listeners: {
			render: function(field) {
				return dateFormatRender(field);
			}
		}
	
	}]
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 456
		},
		items: [{
			xtype : 'textarea',
			fieldLabel : getExaminationTranslation('FACULTY_COMMENTS'),
			name : 'stuFacultyComments',
			itemId:'stuFacultyCommentsItemId',
			maxLength:1000
		},{
			xtype : 'textarea',
			fieldLabel : getExaminationTranslation('STUDENT_COMMENTS'),
			name : 'stuStudentComments',
			itemId:'stuStudentCommentsItemId',
			maxLength:1000
		}]
	},{
		xtype:'fieldcontainer',
		width:'auto',
		style:{'margin-left':'-10px'},
		items: [{
			xtype : 'vwlearningtargetmycoursegradetypegrid',
			name : 'stuLearningTargetGradeGrid',
			itemId:'stuLearningTargetGradeGridItemId',
			hidden:true,
		},{
			xtype : 'vwlearningtargetmycoursemarktypegrid',
			name : 'stuLearningTargetMarkGrid',
			itemId:'stuLearningTargetMarkGridItemId',
			hidden:true
	}]
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getCommonTranslation('SAVE'),
			formBind: true,
			itemId: 'learningTargetSubmit',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE,
			cls: 'btn-with-no-icon'
		}]
	}]});