/**
 * This form is used for student and faculty positive incident actions
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.personinfo.common.disciplinaryactivity.PositiveIncidentForm', {
    //extend: 'Ext.form.Panel',
//	extend:'Academia.view.common.CustomFieldForm',
	extend:'Academia.view.common.IdGeneratorCustomForm',
    customFieldEntity:CONSTANTS.INCIDENT_CF_DATA,
    customFieldEntityType:CONSTANTS.INCIDENT_CF_POSITIVE_INCIDENT_DISPLAY_NAME,
    alias: 'widget.positiveincidentform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'positive_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'nestedJsonCombo',
            itemId : 'categoryOfIncidentCombo',
            fieldLabel: getPersonModuleTranslation('CATEGORY_OF_INCIDENT'),
            name: 'categoryOfIncident',
            valueField: 'id',
            displayField: 'value',
            store: 'common.CategoryOfIncidentStore',
            editable: false,
            allowBlank: false
        }, {
            xtype: 'nestedJsonCombo',
            itemId : 'typeOfIncidentCombo',
            fieldLabel: getPersonModuleTranslation('TYPE_OF_INCIDENT'),
            name: 'type',
            valueField: 'id',
            displayField: 'value',
            store: 'common.IncidentTypeStore',
            editable: false,
            allowBlank: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('INCIDENT_DATE'),
            name: 'incidentDate',
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: false,
            maxValue: new Date()
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('HONOUR_AWARD_NAME'),
            
            name: 'honourName',
            allowBlank: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getPersonModuleTranslation('INCIDENT_RATING'),
            
            store: 'common.IncidentRatingPositiveStore',
            valueField: 'id',
            displayField: 'value',
            //value: 'USER',
            itemId: 'incidentRating',
            name: 'incidentRating',
            allowBlank: false,
            editable: false
        }, {
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('REPORTED_BY'),
            
            store: 'personinfo.common.disciplinaryactivity.ReportedByStore',
            valueField: 'name',
            displayField: 'value',
            value: 'USER',
            itemId: 'reportedByField',
            name: 'reportedBy',
            allowBlank: false,
            editable: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [ {
        	/*xtype: 'livesearchcombo',
            fieldLabel: getPersonModuleTranslation('REPORTED_ID'),
            itemId: 'reportedByUserIdField',
            name: 'reportedByUserId',
            allowBlank: false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            displayTpl: new Ext.XTemplate(
             		'<tpl for="."between=" ">',
             		'{[typeof values === "string" ? values : values["code"]]}' +
             		'</tpl>'
            )*/


        	xtype: 'customcombobox',
        	fieldLabel: getPersonModuleTranslation('REPORTED_ID'),
        	itemId: 'reportedByUserIdField',
        	name: 'reportedByUserId',
        	 store: 'coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
        	allowBlank: false,
        	queryParam:'codeOrName',
        	triggerAction: 'all',
        	forceSelection: true,
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	enableKeyEvents  : 'true',
        	triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        	minChars:3,
        	displayField: 'code', 
        	valueField: 'id',
        	/*displayTpl: new Ext.XTemplate(
         		'<tpl for="."between=" ">',
         		'{[typeof values === "string" ? values : values["code"]]}' +
         		'</tpl>'
     	   )*/
        	listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{value}' +
        			'</div>';
        		}
        	}
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('REPORTED_NAME'),
            
            itemId: 'reportedByUserNameField',
            readOnly: true,
            name: 'reportedByUserName',
            allowBlank: false
        } /*{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('ACTION_TAKEN'),
            
            name: 'actionTaken',
            allowBlank: false
        }*/]
    }, {
        xtype: 'fieldcontainer',
        itemId:'incidentDetailsContainer',
        layout: 'vbox',
        defaults: {
            labelAlign: 'top',
            width: 'auto'
        },
        items: [{
            xtype: 'textareafield',
            width: 536,
            fieldLabel: getPersonModuleTranslation('INCIDENT_DETAILS'),
            name: 'incidentDetails'
        }, {
            xtype: 'textareafield',
            width: 536,
            fieldLabel: getPersonModuleTranslation('REMARK'),
            name: 'remarks'
        }]
    },
	{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		defaults : {
			width: 536,
			labelAlign : 'top'
		},
		items : [{
			xtype:'positiveincidentdocumentgrid',
			itemId:'positiveincidentdocumentgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},
	{
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            itemId: 'cancelButtonId',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE

        },
        {
			 xtype: 'button',
			 //width: 536,
			 name: 'courseSyllabus',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadPositiveIncidentItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
   }]
});
