/**
 *  This grid is used for student positive incident
 *  @author Rohit Thadani
 */
Ext.define('Academia.view.personinfo.common.disciplinaryactivity.PositiveIncidentGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.positiveincidentgrid',
    title: getPersonModuleTranslation('POSITIVE_INCIDENT'),
    border: true,
    isGridConfigurable: true,
    enableColumnHide: false,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnAddStudentsPositive',
        text: getCommonTranslation('ADD_STUDENTS'),
        tooltip: getCommonTranslation('ADD_STUDENTS'),
        disabled: true
    }],
    columns: [{
        header: getPersonModuleTranslation('CATEGORY_OF_INCIDENT'),
        dataIndex: 'categoryOfIncidentValue',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('TYPE_OF_INCIDENT'),
        dataIndex: 'typeValue',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('INCIDENT_DATE'),
        dataIndex: 'studentIncidentDate',
        sortable: false,
        flex: .2
    }, {
        header: getPersonModuleTranslation('INCIDENT_DETAILS'),
        dataIndex: 'incidentDetails',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('HONOUR_AWARD_NAME'),
        dataIndex: 'honourName',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('INCIDENT_RATING'),
        dataIndex: 'incidentRatingValue',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('REPORTER_NAME'),
        dataIndex: 'reportedByUserName',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('STUDENTS_INVOLVED'),
        //itemId: 'employeesInvolvedItemId',
        itemId: 'studentsInvolvedItemId',
        dataIndex: 'studentsInvolved',
        sortable: true,
        flex: .2,
		renderer:function(value, meta, record){
			var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
			var portalId = baseController.getCurrentLoggedPortalId();
			if(!isNullOrEmpty(value) && portalId!=3 && portalId!=7) {	
				var grid = this.up().down('grid');
				var studentsInvolvedItemId = grid.down('#studentsInvolvedItemId');
    			var index = studentsInvolvedItemId.getIndex();
    			if(grid.itemId=="studentPositiveIncidentGrid"){
    				return '<a href=#>'+value+'<a>';
    			} else {
    				return value;
    			}
			}else if(!isNullOrEmpty(value)){
				var grid = this.up().down('grid');
				var studentsInvolvedItemId = grid.down('#studentsInvolvedItemId');
    			var index = studentsInvolvedItemId.getIndex();
    			if(grid.itemId=="studentPositiveIncidentGrid"){
    				return value;
    			} else {
    				return value;
    			}
			}
			return '';
		}
    },
    /*{
        header: getPersonModuleTranslation('ACTION_TAKEN'),
        dataIndex: 'actionTaken',
        sortable: true,
        flex: .2
    }, */{
        header: getPersonModuleTranslation('REMARK'),
        dataIndex: 'remarks',
        sortable: true,
        flex: .2
    }, {
    	header:  getPersonModuleTranslation('DOCUMENTS'),
		dataIndex: 'documents',
		sortable:true,
		//hidden:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.documents.length>1) {					
					return '<a href=#>'+record.data.documents.length+'<a>';
				} else if(record.data.documents.length==1) {
					return '<a href=#>'+record.data.documents[0].name+'<a>';
				} 
			}                        
		}
	}],
	listeners: {
        selectionchange: {
            fn: function(model, selected) {
                model.view.up().down('#btnAddStudentsPositive').setDisabled(!selected.length);
            },
            scope: this
        },
        afterrender: function(grid){
        	try{
        		setTimeout(function(){
        			//var employeesInvolvedItemId = grid.down('#employeesInvolvedItemId');
        			var studentsInvolvedItemId = grid.down('#studentsInvolvedItemId');
        			var index = studentsInvolvedItemId.getIndex();
        			if(grid.itemId=="studentPositiveIncidentGrid"){
        				grid.columns[index].setText(getCommonTranslation('STUDENTS_INVOLVED'))
        			} else {
        				grid.columns[index].setText(getCommonTranslation('EMPLOYEES_INVOLVED'))
        				
        			}
        		},300);
        	}
        	catch(e){
        		console.log("");
        	}
        }
    },
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.disciplinaryactivity.PositiveIncidentStore');
    }

});