Ext.define('Academia.view.personinfo.common.disciplinaryactivity.SanctionDetailsGridOnWindow', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.sanctiondetailsgridonwindow',
	store: 'personinfo.common.disciplinaryactivity.DisciplinarySanctionDetailGridWindowStore',
	title: getPersonModuleTranslation('ADD_SANCTION_DETAILS'),
	border: true,
	autoScroll: false,
	frame: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
				xtype: 'custompagingtoolbar',
				itemId:'managePaggingToolBarItemId',
				plugins:['pagesize'],
			    store : 'personinfo.common.disciplinaryactivity.DisciplinarySanctionDetailGridWindowStore',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
		}]
	}],
	columns: [{
		header: getPersonModuleTranslation('SANCTION_TYPE'),
		dataIndex: 'sanctionType',
		flex: 1,
		editor: {
			xtype: 'customcombobox',
			name: 'sanctionType',
			itemId: 'sanctionTypeItemId',
			store:Ext.create('Academia.store.personinfo.common.disciplinaryactivity.DisciplinarySanctionTypeSUStore'),
			allowBlank: true,
			displayField : 'value',
			valueField : 'id',
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        	enableKeyEvents  : 'true',
        	hideTrigger:false,
        	forceSelection:true,
        	triggerAction: 'all',
			queryParam:'id',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			minChars:3,
			listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        			
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{code} / {value}'  +
        			'</div>';
        		}
        	}
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    			if(!isNullOrEmpty(value) && value !== '') {
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('sanctionType');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName.value;
    				}
    			}
    			else{
    				if(Ext.isDefined(record.get('sanctionType')) && isNullOrEmpty(record.get('sanctionType'))){
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
		}

	}, {
		header: getPersonModuleTranslation('SANCTION_COMPLETION_DATE'),
		dataIndex: 'sanctionDate',
		flex: 1,
		sortable: true,
		allowBlank: false,
		editor: {
			xtype: 'datefield',
			name: 'sanctionCompletionDate',
			itemId: 'sanctionCompletionDate',
			maxLength: 100
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return dateRender(val);
			}
		}
	},{
		header: getPersonModuleTranslation('SANCTION_RECALL_DATE'),
		dataIndex: 'sanctionRecallDate',
		flex: 1,
		sortable: true,
		editor: {
			xtype: 'datefield',
			name: 'sanctionRecallDate',
			itemId: 'sanctionRecallDateItemId',
			maxLength: 100,
		},
		renderer: function(val, rec,date) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return dateRender(val);
			}
		}
	},{
		header: getPersonModuleTranslation('SANCTION_COMPLETE'),
		dataIndex: 'whetherSanctionCompleted',
		flex: 1,
		sortable: true,
		editor: {
			xtype: 'customcombobox',
			name: 'sanctionComplete',
			itemId: 'sanctionCompleteItemId',
			displayField : 'value',
			valueField : 'value',
			maxLength: 100,
			forceSelection: true,
			editable: false,
			listeners: {
				focus: function(combo, eOpt) {
					combo.setRawValue(combo.getValue());
				},
				blur: function(combo, r) {
					combo.setValue(combo.getValue());
				},
				render: function(combo) {
					var store = Ext.create('Academia.store.personinfo.common.disciplinaryactivity.SanctionCompletedStore');
					combo.bindStore(store);
				},
				change: function(combo, eOpt) {
					combo.setRawValue(combo.getValue());
				}
			}
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				if(val == true ||val == 'Yes'){
					return 'Yes';
				}else{
					return 'No';
				}
			}
		}
	},{

		header: getPersonModuleTranslation('APPEAL'),
		dataIndex: 'appealOutcome',
		flex: 1,
		editor: {
			xtype: 'customcombobox',
			name: 'appeal',
			itemId: 'appealItemId',
			store:'personinfo.common.disciplinaryactivity.DisciplinarySUAppealOutcome',
			displayField : 'value',
			valueField : 'id',
			triggerAction: 'all',
			forceSelection: true,
			//queryParam:'name',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			minChars:3,
			enableKeyEvents : 'true',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
			} 
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
	
			if(!isNullOrEmpty(value) && value !== '') {
				var editor = rec.column.getEditor();
				var recTypeName = record.get('appealOutcome');
				editor.store.load();
				if(!isNullOrEmpty(recTypeName)){
					return recTypeName.value;
				}
			}
			else{
				if(Ext.isDefined(record.get('appealOutcome')) && isNullOrEmpty(record.get('appealOutcome'))){
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			}	
		}
	},{
		header: getPersonModuleTranslation('SANCTION_HOURS'),
		dataIndex: 'sanctionHours',
		flex: 1,
		sortable: true,
		editor: {
			xtype: 'numberfield',
			name: 'sanctionHours',
			itemId: 'sanctionHoursItemId',
			maxLength: 100,
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return val;
			}
		}
	}],
	plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1
    }
});
