/**
 * @author prakash sharma
 */
Ext.define('Academia.view.personinfo.common.documentrequested.DocumentRequestedWinGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.documentrequestedwingrid',
    selType:'checkboxmodel',
    title: getPersonModuleTranslation('LIST_OF_DOCUMENTS'),
    border: true,
    autoScroll: true,
    itemId:'ApplicantListOfDocument',
    height : 250,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'button',
		itemId : 'downloadDocumentItemId',
		tooltip : getCommonTranslation('DOWNLOAD_ALL'),
		text : getCommonTranslation('DOWNLOAD_ALL'),
		formBind:true,
	}],
	columns : [{
		text : getCommonTranslation('S_NO'),
		dataIndex: 'serialNo',
		sortable : false,
		flex:0.2
	}, {
		text :  getCommonTranslation('DOCUMENTS'),
		dataIndex : 'name',
		sortable : false,
		flex:0.2
	},{
		text :  getCommonTranslation('FILE_TYPE'),
		dataIndex : 'documentFormat',
		sortable : false,
		flex:0.2
	},{
		text :getCommonTranslation('UPLOADED_ON'),
		dataIndex: 'submissionDate',
		sortable : false,
		renderer: function(value){
			return dateRender(value);
		},
		flex:0.2
	}, {
		text : getCommonTranslation('STATUS'),
		dataIndex: 'documentStatus',
		sortable : false,
		flex:0.2
	},{
		text :  getCommonTranslation('REFERENCE_DOCUMENT'),
		dataIndex : 'referenceDocumentId',
		sortable : false,
		flex:0.2,
		renderer: function(value, metadata, record) {
    		var msg = "";
    		if(!isNullOrEmpty(record.raw.referenceDocumentId)) {
    			if( portalId == 6 ){
    				if(!isNullOrEmpty(record.raw.referenceDocumentName)) {
    					msg = '<a href="#">Download</a>';
    				}
    			} else {
    				msg = '<a href="#">' +record.raw.referenceDocumentName + '</a>';
    			}
    			
    		}
    		return msg;
    	}
	},{
		text : getCommonTranslation('UPLOAD'),
		dataIndex: 'upload',
		sortable : false,
		flex:0.25,
		renderer : function(value) {
			return '<span><button style="background-color:green;color:white;font-size:10.5px;">Upload Document</button>';
		}
	}],
	initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store:store ,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
       // this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.common.documentRequstedByGroupMasterId');
    }
});
