/**
 * This form is used for applicant document quick search form
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.personinfo.common.documents.DocumentSearchForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.documentsearchform',
	plugins: "formlabelrequired",
	items:[{
		xtype : 'form',
		cls:'customSearchPanel',
		isMinWidthNotRequired: true,
		defaults : {
			labelAlign : 'top',
		},
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'academyLocation',
				itemId: 'academyCombo',
				labelAlign: 'top',
				width: 350,
				style :{marginLeft: '10px'},
				displayField: 'value',
				store:'user.UserAcademyLocationWithApplicantStore',
				valueField: 'id',
				fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
				queryParam:'qry',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('PROGRAM'),
				name : 'program',
				itemId : 'programId',
				store:'common.ProgramByApplicantStore',
				displayField:'value',
				valueField:'id',
				labelAlign: 'top',
				width: 256,
				typeAhead:true,
				forceSelection:true,
//				allowBlank:false,
				disabled : true,
				queryParam:'programName',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('BATCH'),
				name: 'batch',
				itemId: 'batchCombo',
				displayField: 'value',
				valueField: 'id',
				width: 256,
				labelAlign: 'top',
				disabled : true,
				store:'common.BatchesByProgramId',
				typeAhead:true,
				forceSelection:true,
			}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'customcombobox',
				name: 'seatType',
				style :{marginLeft: '10px'},
				itemId: 'seatTypeCombo',
				displayField: 'seatTypeName',
				valueField: 'seatTypeId',
				width: 256,
				labelAlign: 'top',
				disabled : true,
				fieldLabel: getCommonTranslation('SEAT_TYPE'),
				store:'common.SeatTypesByBatchId'
			},{
				xtype: 'customcombobox',
				width: 256,
				style :{marginLeft: '10px'},
				itemId: 'selectionStageCombo',
				name:'selectionStage',
				store: 'Academia.store.admission.selectionStage.SelectionStageFromSeatType',
				fieldLabel: getAdmissionTranslation('SELECT_STAGE'),
				labelAlign: 'top',
				displayField: 'value',
				valueField: 'id',
				queryMode: 'local',
				editable:false,
				disabled : true,
				autoload: false,
				emptyText: getCommonTranslation('SELECT')
			}]
		}, {
			xtype: 'fieldcontainer',
			width: 'auto',
			layout:'hbox',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchButtonId',
				ui: 'CustomBtnSubmit',
				formBind: true,
				scale: CONSTANTS.BUTTONSIZE
			}, {
				xtype: 'button',
				text: getCompletionModuleTranslation('CLEAR_SEARCH'),
				itemId: 'clearSearch',
				buttonAlign: 'right',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});