/**
 * 
\ * @author Ankur Jaiswal
 */
Ext.define('Academia.view.personinfo.common.documents.OnlineDocumentFormWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.onlinedocumentformwin',
    title: getPersonModuleTranslation('DOCUMENTS_DETAILS'),
    plugins: "formlabelrequired",
    autoScroll: true,
    modal: true,
    height: '60%',
    width:712,
    items: [{
        xtype: 'form',
        itemId: 'onlineDocumentFormItemId',
        items: [{
            xtype: 'hidden',
            itemId: 'document_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'module'
        }, {
            xtype: 'hidden',
            name: 'entityId'
        }, {
            xtype: 'hidden',
            name: 'entityType'
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            items: [{
                xtype: 'radiogroup',
                itemId: 'documentType',
                style: {
                    marginLeft: '8px'
                },
                width:712,
                defaults: {
                    flex: .1
                },
                items: [{
                    boxLabel: getPersonModuleTranslation('DOC_PREDFINED_DOCUMENTS'),
                    itemId: 'predifinedocument',
                    name: 'isPreDefined',
                    inputValue: true,
                    checked: true
                }, {
                    boxLabel: getPersonModuleTranslation('OTHERS'),
                    itemId: 'othersItemId',
                    name: 'isPreDefined',
                    //itemId: 'other',
                    inputValue: false,
                },{
                    boxLabel: getCommonTranslation('FEE_PAYER_DOCUMENTS'),
                    itemId: 'feePayerItemId',
                    name: 'isPreDefined',
                    inputValue: 'feePayer',
                }]
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'nestedJsonCombo',
                fieldLabel: getPersonModuleTranslation('DOCUMENTS_TYPE'),
                //store: 'common.DocumentTypeStore',
                store: Ext.create('Academia.store.common.DocumentTypeStore'),
                name: 'documentType',
                displayField: 'value',
                valueField: 'id',
                forceSelection: true,
                editable: false,
                allowBlank: false,
                itemId: 'documentTypeCombo'
            }, {
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('DOCUMENTS_NAME'),
                name: 'documentName',
                itemId: 'documentNameItemId',
                readOnly: false,
                allowBlank: false,
                hidden: true,
            }, {
                xtype: 'datefield',
                fieldLabel: getPersonModuleTranslation('DATE_SUBMISSION'),
                name: 'submissionDate',
                itemId: 'submissionDate',
                readOnly: true,
              //--submitFormat: CONSTANTS.DATE_FORMAT,
                allowBlank: false,
                listeners: {
                    render: function(obj) {
                        obj = dateFormatRender(obj);
                        obj.setValue(new Date());
                    }
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            itemId: 'fileFieldContainer',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'filefield',
                itemId: 'uploadFileField',
                region: 'south',
                ui: 'CustomBtnSubmit',
                fieldLabel: getPersonModuleTranslation('SELECT_FILE'),
                buttonText: getPersonModuleTranslation('UPLOAD'),
                allowBlank: false,
                name: 'file'
            }, {
                xtype: 'textfield',
                itemId: 'remarkItemId',
                fieldLabel: getPersonModuleTranslation('REMARK'),
                name: 'remark',
                maxLength: 255,
                readOnly: false,
                allowBlank: true
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            itemId: 'fileInfoContainer',
            hidden: true,
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'displayfield',
                itemId: 'docDetails'
            }]
        }, {
            xtype: 'radiogroup',
            itemId: 'inspectionDoneRadioGroupField',
            fieldLabel: getPersonModuleTranslation('INSPECTION_DONE'),
            columns: 2,
            vertical: true,
            hidden: true,
            labelWidth:105,
            name: 'isInspectionDone',
            items: [{
                itemId: 'isInspectionDoneYesField',
                boxLabel: getPersonModuleTranslation('YES'),
                name: 'isInspectionDone',
                inputValue: true
            }, {
                itemId: 'isInspectionDoneNoField',
                boxLabel: getPersonModuleTranslation('NO'),
                name: 'isInspectionDone',
                inputValue: false,
                checked: true
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            itemId: 'inspectionDateContainer',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'datefield',
                itemId: 'inspectionDateField',
                fieldLabel: getPersonModuleTranslation('INSPECTED_DATE'),
                name: 'inspectionDate',
                allowBlank: false,
              //--submitFormat: CONSTANTS.DATE_FORMAT,
                hidden: true,
                disabled: true,
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                }
            }, {
                xtype: 'livesearchcombo',
                itemId: 'inspectionDoneByField',
                fieldLabel: getPersonModuleTranslation('INSPECTED_BY'),
                minChars: 3,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                name: 'inspectionDoneBy',
                forceSelection: true,
                allowBlank: false,
                hidden: true,
                disabled: true
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            	xtype: 'nestedJsonCombo',
                itemId: 'documentStatus',
                fieldLabel: getPersonModuleTranslation('STATUS'),
                store: 'common.DocumentStatusCSMStore',
                name: 'documentStatusCSM',
                valueField: 'id',
                displayField: 'value',
                readOnly: true,
                editable: false,
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            style: {
                marginTop: '17px',
                marginLeft: '-2px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'),
                itemId: 'documentFormSubmitButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                buttonAlign: 'right',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'documentCancelButtonId',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});