/**
 * This grid is used for student and faculty feedback received
 * @author Sachin.Bangar 
 */

Ext.define('Academia.view.personinfo.common.feedback.FeedbackReceivedGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.feedbackreceivedgrid',
    title: getPersonModuleTranslation('FEEDBACK_RECEIVED_DETAILS'),
    border: true,
    autoScroll: true,
    viewConfig: {
        stripeRows: true
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'personinfo.common.feedback.FeedbackReceiveStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    tbar: [{
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }],
    columns: [{
        header: getPersonModuleTranslation('QUESTIONNAIRE_NUMBER'),
        dataIndex: 'questionnaireNumber',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('COURSE_NAME'),
        dataIndex: 'courseName',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('FEEDBACK_GIVEN_BY'),
        dataIndex: 'feedbackGivenBy',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('STATUS'),
        dataIndex: 'status',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('COMPLETION_DATE'),
        dataIndex: 'completionDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }],

    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.feedback.FeedbackReceiveStore');
    }

});