/**
 * This is used to show student KYS Details form
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.personinfo.common.kys.KYSDetailsForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.kysdetailsform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    defaults: {
        labelAlign: 'top',
        width: 256
    },
    items: [{
        xtype: 'hidden',
        itemId: 'kys_hidden_field',
        name: 'id'
    }, {
    	xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'datefield',
        fieldLabel:getPersonModuleTranslation('SUBMISSION_DATE'),
        name: 'submissionDate',
        allowBlank: false,
        listeners: {
        	render: function(field) {
        		return dateFormatRender(field);
        	}
        },
      //--submitFormat: CONSTANTS.DATE_FORMAT
    }, {
        xtype: 'numberfield',
        fieldLabel:getPersonModuleTranslation('NO_OF_DAYS_OVERDUE'),
        name: 'daysOverdue',
        minValue: 0,
        allowBlank: false
    }, {
        xtype: 'datefield',
        fieldLabel:getPersonModuleTranslation('LAST_DATE_OF_SUBMISSION'),
        name: 'lastSubmissionDate',
        allowBlank: false,
        listeners: {
        	render: function(field) {
        		return dateFormatRender(field);
        	}
        },
      //--submitFormat: CONSTANTS.DATE_FORMAT
    }, {
        xtype: 'customcombobox',
        fieldLabel: getPersonModuleTranslation('STATUS'),
        name: 'status',
        valueField: 'id',
        displayField: 'value',
        store: 'personinfo.common.services.KYSStatusStore',
        editable: false,
        allowBlank: false
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});