/**
 * @author Swapnil Patil
 */
Ext.define('Academia.view.personinfo.common.pasthistory.ApplicantDetailsForm', {
    //extend: 'Ext.form.Panel',
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.applicantdetailsform',
    border: false,
    frame: true,
    title: getPersonModuleTranslation('APPLICANT_DETAILS_FORM'),
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'applicantionItemId',
        name: 'id'
    },{
        xtype: 'hidden',
        itemId: 'version',
        name: 'version'
    },{
        xtype: 'hidden',
        itemId: 'applicantPersonId',
        name: 'applicantPersonId'
    },{
    	 xtype: 'hidden',
         itemId: 'enquiryStudentDetailItemId',
         name:'enquiryStudentDetailId'
    },{
	   	 xtype: 'hidden',
	     itemId: 'photoUrlItemId',
	     name: 'photoUrl'
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	layout: 'hbox',
    	defaults: {
    		labelAlign: 'top',
    	},
    	items:[{
    		xtype: 'radiogroup',
    		itemId:'applicantTypeId',
//    		columns: 2,
//    		vertical: true,
    		items: [{ 
    			boxLabel: getAdmissionTranslation('FRESH_APPLICANT'), 
    			name: 'saleRefType', // applicantType
    			inputValue: "NEW_APPLICANT",
    			checked:true
    		},
    		{ 
    			boxLabel: getAdmissionTranslation('ENQUIRED_EARLIER'), 
    			name: 'saleRefType', // applicantType
    			inputValue: "ENQUIRED_EARLIER"
    		}]
    	}]
    },{
    	xtype: 'fieldcontainer',
		itemId: 'academicDetails',
		//padding: 10,
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype: 'textfield',
			itemId : 'personCodeField',
			fieldLabel: getPersonModuleTranslation('APPLICANT_ID'),
			name: 'applicantId',
			emptyText: getCommonTranslation('ID_AUTOGENERATE'),
			readOnly: true,
			allowBlank: true
		},{
			xtype: 'photouploadform',
			itemId: 'applicantPhotoUploadForm'
			
		},{
        	html: '<i>'+getCommonTranslation('APPLICANT_PLEASE_PREFER_IMAGE_SIZE_TYPE')+'</i>',
        	style:{'margin-top':'25px !important'}
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: 'hbox',
        items: [{
            xtype: 'textfield',
            name: 'enquiryId',
            itemId: 'enquiryIdItemId',
            fieldLabel: getAdmissionTranslation('ENQUIRY_ID'),
            allowBlank: false,
            maxLength: 255,
            hidden:true,
        }, {
			xtype: 'textfield',
			fieldLabel: getAdmissionTranslation('EMAIL_ADDRESS'),
			name: 'emailId',
			vtype: 'email',
			itemId: 'emailId',
			allowBlank: false,
			hidden:true,
		}, {
            xtype: 'button',
            style:{marginTop:'30px !important'},
            text: getCommonTranslation('FETCH_DETAILS'),
            itemId: 'FetchEnquiryDetailId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            hidden:true,
        }]
    },{
    	xtype: 'fieldcontainer',
//    	width: '100%',
//    	layout: 'hbox',
    	/*style:{
    		height:'30px !important'
    	},*/
    	defaults: {
    		labelAlign: 'top',
    		width: 256
    	},
    	items:[{
    		xtype: 'radiogroup',
    		itemId:'isUniversityItemId1',
			fieldLabel:getAdmissionTranslation('HAVE_YOU_EVER_BEEN_REGISTER_UNIVERSITY'),
			width:330,
    		items: [{ 
    			boxLabel: getAdmissionTranslation('YES'), 
    			name: 'isRegisteredUniversity', 
    			inputValue: true
    		},{ 
    			boxLabel: getAdmissionTranslation('NO'), 
    			name: 'isRegisteredUniversity', 
    			inputValue: false,
    			checked:true
    		}]
    	},{
            xtype: 'textfield',
            name: 'registeredStudentId',
            itemId: 'studentIdItemId',
            fieldLabel: getAdmissionTranslation('REGISTRATION_NO'),
            allowBlank: false,
            //maxLength: 255,
            hidden:true,
        }]
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 256
    	},
    	layout: 'hbox',
    	items: [{
    		xtype: 'textfield',
    		name: 'firstName',
    		itemId: 'firstName',
    		fieldLabel: getAdmissionTranslation('FIRST_NAME'), //First Name
    		allowBlank: false,
    		//vtype: 'spaceAndSpecialCharactersAsInput'
    	},{
    		xtype: 'textfield',
    		name: 'middleName',
    		itemId: 'middleName',
    		fieldLabel: getAdmissionTranslation('MIDDLE_NAME'), //Middle Name
    		//vtype: 'spaceAndSpecialCharactersAsInput'
    	},{
			xtype: 'textfield',
			name: 'lastName',
			itemId: 'lastName',
			allowBlank: false,
			fieldLabel: getAdmissionTranslation('LAST_NAME'), //Last Name       
			//vtype: 'spaceAndSpecialCharactersAsInput',
		}]
    },{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [ {
			xtype: 'nestedJsonCombo',
			fieldLabel: getPersonModuleTranslation('NATIONALITY'),
			itemId: 'nationalityCombo',
			store: 'common.NationalityStore',
			valueField: 'id',
			displayField: 'value',
			name: 'nationality',
//			queryMode: 'local',
			allowBlank: false,
			editable: false
		},{
			xtype: 'textfield',
		    name: 'nationalID',
		    itemId: 'nationalIDItemId',
		    fieldLabel: getPersonModuleTranslation('NATIONAL_ID'),
		    maxLength: 50,
		    vtype: 'SpecialCharactersWithNumberWithoutSpaceAsInput',
		    allowBlank: false
		},{
			xtype: 'datefield',
			fieldLabel: getPersonModuleTranslation('DATE_OF_BIRTH'),
			itemId: 'birthDateId',
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			name: 'birthDate',
			maxValue: new Date(),
			allowBlank: false,
			listeners: {
				render : function(dateField){
					return dateFormatRender(dateField);
				}}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('GENDER'),
			itemId: 'genderCSM',
			name: 'genderCSM',
			valueField: 'id',
			displayField: 'value',
			store: 'Academia.store.common.GenderTypeStore',
			queryMode: 'local',
			editable: false,
			allowBlank: false
		},{
			xtype: 'customcombobox',
			fieldLabel: getPersonModuleTranslation('MARITAL_STATUS'),
			store: 'common.MaritalStatusStore',
			valueField: 'id',
			displayField: 'value',
			name: 'maritalStatus',
			itemId:'maritalStatusId',
			editable: false
		}]
	},{
        xtype: 'fieldcontainer',
        style: {
            marginLeft: '-2px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }]
    }]
});