Ext.define('Academia.view.personinfo.common.pasthistory.ApplicantHealthInformationDocumentListGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.applicanthealthinformationdocumentlistgrid',
	store :'personinfo.common.pasthistory.ApplicantHealthInformationDocumentGridStore',
	border: true,
	autoScroll: false,
	//height:'80%',
	//maxWidth:'850',
	frame:false,
	enableColumnHide :false,
	isFixHeightGrid: true,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	title : getCommonTranslation('LIST_OF_DOCUMENTS'),
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'personinfo.common.pasthistory.ApplicantHealthInformationDocumentGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
	this.callParent(arguments);
	},
	
	tbar: [{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
				
	},{
		xtype : 'button',
		itemId : 'downloadDocumentItemId',
		tooltip : getCommonTranslation('DOWNLOAD_ALL'),
		text : getCommonTranslation('DOWNLOAD_ALL'),
		formBind:true,
	}],
	columns :[{
		header : getCommonTranslation('S_NO'),
		xtype: 'rownumberer',
		align: 'left',
		flex: 0.5,
		renderer: function(value, metaData, record, rowIndex){
			return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
		}
	},{
		header : getCommonTranslation('DOCUMENTS'),
		dataIndex : 'documentName',
		sortable:false,
		flex:1,
		renderer:function(value, metaData, record){
			if(record){
				var pathSplit=record.data.path.split('/');
	            var newPath=pathSplit[2];
				var newvalue=!isNullOrEmpty(value)?value:newPath;
				return "<a href='#'>"+newvalue+"</a>";
			}
		}
	},{
		header : getCommonTranslation('UPLOADED_ON'),
		dataIndex : 'submissionDate',
		sortable:false,
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
	}]
});