/**
 *  Church Information Grid
 */
Ext.define('Academia.view.personinfo.common.pasthistory.ChurchInformationGrid', {
   // extend: 'Ext.grid.Panel',
    alias: 'widget.churchinformationgrid',
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    title: getPersonModuleTranslation('CHURCH_INFORMATION_DETAILS_GRID'),
    cls : 'chruchGridTitleWidth',
    border: true,
	frame:false,
    viewConfig: {
        stripeRows: true
    },

    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    }],
    columns: [{
        header: getPersonModuleTranslation('CHURCH_AFFILIATION'),
        dataIndex: 'churchAffiliation',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('NAME_OF_LOCAL_CHURCH_PARISH'),
        dataIndex: 'localChurchName',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('MEMBERSHIP_STATUS'),
        dataIndex: 'churchMembershipStatusMappings',
        sortable: true,
        flex: .2,
        renderer:function(record){
        	var result='';
        	for(var i in record){
        		result=result.concat(record[i].membershipStatus.membershipStatus);
        		result=result.concat(",");
        	}
        	return result.substring(0,result.length-1);
        }
    },{
		header:  getPersonModuleTranslation('CHURCH_EMPLOYMENT_HISTORY'),
		dataIndex: 'churchEmployments',
		flex:.2,
		sortable:true,
		renderer:function(record){
			if(record.length>0){
				return "<a href='#'>"+getPlacementTranslation('VIEW')+"</a>";
			}else{
				return "-";
			}
			
		}   
	
	}],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.pasthistory.ChurchInformationStore');
    }

});