/**
 *   Emplolyee Insurance History Form 
 */
Ext.define('Academia.view.personinfo.common.pasthistory.EmployeeInsuranceHistoryForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.employeeinsurancehistoryform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'employee_insurance_history_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, 
	{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
    		xtype: 'textfield',
    		fieldLabel: getPersonModuleTranslation('INSURANCE_TYPE'),
    		name: 'insuranceType',
    		itemId:'insuranceType',
    	},
    	{
    		xtype: 'textfield',
    		fieldLabel: getPersonModuleTranslation('INSURANCE_PROVIDER'),
    		name: 'insuranceProvider',
    		itemId:'insuranceProvider'
    	}
		]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
    		xtype: 'datefield',
    		fieldLabel: getPersonModuleTranslation('INSURANCE_DATE'),
    		name: 'insuranceDate',
    		itemId:'insuranceDate',
    		vtype: 'daterange',
			endDateField: 'insuranceExpiryDate',
			editable:false,
    		listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			
    	},
    	{
    		xtype: 'datefield',
    		fieldLabel: getPersonModuleTranslation('INSURANCE_EXPIRY_DATE'),
    		name: 'insuranceExpiryDate',
    		itemId:'insuranceExpiryDate',
    		vtype: 'daterange',
			editable:false,
    		listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
    	}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
    		xtype: 'numberfield',
    		fieldLabel: getPersonModuleTranslation('SUM_INSURED'),
    		name: 'sumInsured',
    		itemId:'sumInsured',
    		minValue:0,
    	}]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SAVE'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
    
 

    
});
