/**
 * @author swapnil.patil
 * Physical Characteristics Form 
 */
Ext.define('Academia.view.personinfo.common.pasthistory.EmployeePhysicalCharacteristicsForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.employeephysicalcharacteristicsform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'phyChar_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, 
	{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
    		xtype: 'numberfield',
    		fieldLabel: getPersonModuleTranslation('HEIGHT'),
    		name: 'height',
    		itemId:'height',
    		maxLength: 5,
    		minLength: 2,
    		minValue:10,
    		enforceMaxLength: true,
    		allowBlank: false
    	},
    	{
    		xtype: 'numberfield',
    		fieldLabel: getPersonModuleTranslation('WEIGHT'),
    		name: 'weight',
    		itemId:'weight',
    		maxLength: 5,
    		minLength: 2,
    		minValue:10,
    		enforceMaxLength: true,
    		allowBlank: false
    	}
		]
    },
	{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
			xtype: 'customcombobox',
			fieldLabel: getPersonModuleTranslation('EYE_COLOR'),
			name: 'eyeColor',
			itemId:'eyeColor',
			store: 'common.ColorStore',
			valueField: 'id',
			displayField: 'value',
			queryMode: 'remote',
			editable: false
		},
		{
			xtype: 'customcombobox',
			fieldLabel: getPersonModuleTranslation('HAIR_COLOR'),
			name: 'hairColor',
			itemId:'hairColor',
			store: 'common.ColorStore',
			valueField: 'id',
			displayField: 'value',
			queryMode: 'remote',
			editable: false
		}
		]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256,
        },
        items: [{
            xtype: 'datefield',
            name: 'updatedDate',
            itemId: 'updatedDate',
          //--submitFormat:CONSTANTS.DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			allowBlank:false,
            fieldLabel: getPersonModuleTranslation('PHYSICAL_CHAR_DATE')
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
    
 

    
});
