/**
 *  Medical History Grid
 */
Ext.define('Academia.view.personinfo.common.pasthistory.MedicalGrid', {
	// extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.medicalgrid',
	title: getPersonModuleTranslation('MEDICAL_HISTORY'),
	border: true,
	viewConfig: {
		stripeRows: true
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns: [{
		header: getPersonModuleTranslation('CONDITION_TYPE'),
		dataIndex: 'conditionType',
		sortable: true,
		flex: .2,
		renderer : function(obj) {
			return columnObjRender(obj, "value");
		}
	}, {
		header: getPersonModuleTranslation('MEDICAL_CONDITION'),
		dataIndex: 'medicalCondition',
		sortable: true,
		flex: .2
	}, {
		header: getPersonModuleTranslation('SINCE_WHEN'),
		dataIndex: 'dateSince',
		sortable: true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header: getPersonModuleTranslation('CONSULTING_DOCOTR'),
		dataIndex: 'consultingDoctor',
		sortable: true,
		flex: .2
	}, {
		//header: getPersonModuleTranslation('REMARK')
		header: getPersonModuleTranslation('PRECAUTION_MEDICATION'),
		dataIndex: 'remarks',
		sortable: true,
		flex: .2
	}],

	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.personinfo.common.pasthistory.MedicalHistoryStore');
	}

});