/**
 * @author Amit G Post School Studies Form
 */
Ext.define('Academia.view.personinfo.common.pasthistory.PostSchoolStudiesForm', {
    extend: 'Academia.view.common.DynamicFieldForm',
    alias: 'widget.postschoolstudiesform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    width:1100,
    listeners:{
    	labelAlign: 'top'
    },
    items: [{
        xtype: 'hidden',
        itemId: 'postSchool_hidden_field',
        name: 'id'
    },{
        xtype: 'hidden',
        itemId: 'certificateDocPath',
        name: 'certificateDocPath'
    },{
        xtype: 'hidden',
        itemId: 'transcriptDocPath',
        name: 'transcriptDocPath'
    },{
		xtype : 'hidden',
		name : 'module'
	}, {
		xtype : 'hidden',
		name : 'entityId'
	}, {
		xtype : 'hidden',
		name : 'entityType'
	},{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items:[{
			   xtype: 'nestedJsonCombo',
			   fieldLabel: getCommonTranslation('QUALIFICATION_TYPE'),
			  store:Ext.create('Academia.store.personinfo.common.personalinfo.QualificationTypeStore'),
			   itemId: 'qualificationType',
			   allowBlank: true,
			   valueField: 'id',
			   displayField: 'value',
			   name: 'qualificationType',
			   editable: false,
	           disableKeyFilter: false,
	           forceSelection:true
		   },{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('QUALIFICATION_NAME'),            
            maxLength:50,
			//allowBlank: false,
            name: 'qualificationName',
            itemId:'qualificationNameItemId',
        },{
			 xtype: 'customcombobox',
			 fieldLabel: getCommonTranslation('COMPLETED'),
			 store: Ext.create('Academia.store.common.StoCompletedValueYesNoStore'),
			 itemId: 'completedComboItemId',
			// allowBlank: false,
			 valueField: 'id',
			 displayField: 'value',
			 name: 'completedCombo',
			 editable: false,
			 width:180
		 
        },{
            xtype: 'numberfield',
            fieldLabel: getCommonTranslation('NUMBER_OF_SEMESTER_COMPLETED'),   
            maxLength:2,
            minValue:0,
			hidden:true,
			hideTrigger:true,
			allowDecimals:false,
			allowExponential :false,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
            name: 'noOfSemestersCompleted',
            itemId:'noOfSemesterCompletedItemId',
            width:266,
            maskRe: /[0-9]/
        }]
     },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
     items: [{
		 xtype: 'datefield',
		 name: 'periodFrom',
		 itemId: 'periodFrom',
		 fieldLabel: getCommonTranslation('PERIOD_FROM'),
		 editable: true,
		 allowBlank: true,
		 vtype: 'daterange',
		 endDateField: 'periodTo',
		 listeners: {
			 render: function(field) {
				 return dateFormatRender(field);
			 }
		 }
	 },{
		 xtype: 'datefield',
		 name: 'periodTo',
		 itemId: 'periodTo',
		 fieldLabel: getCommonTranslation('PERIOD_TO'), 
		 editable: true,
		 allowBlank: true,
		 vtype: 'daterange',
		 startDateField: 'periodFrom',
		 disabled:true,
		 listeners: {
			 render: function(field) {
				 return dateFormatRender(field);
			 }
		 }
	 },{
    	 xtype: 'textfield',
    	 fieldLabel: getCommonTranslation('DOCTRAL_THESIS'),
    	 maxLength:100,
    	 allowBlank: true,
    	 //hidden:true,
    	 name: 'doctoralThesis',
    	 itemId:'doctoralThesisId',
     }]
     },{
         xtype: 'fieldcontainer',
         layout: 'hbox',
         defaults: {
             labelAlign: 'top',
             width: 256
         },
         items:[{
        	 xtype: 'customcombobox',
        	 fieldLabel: getCommonTranslation('INSTITUTION_NAME'),
        	 store: Ext.create('Academia.store.personinfo.common.personalinfo.StoFindAllInstitutePostSchoolStudiesStore'),
        	 itemId: 'institutionNameItemId',
        	 valueField: 'id',
        	// allowBlank: false,
        	 displayField: 'value',
        	 name: 'institutionName',
        	 forceSelection:true,
        	 autoload: true,
        	 queryParam:'codeOrValue',
        	 minChars:3,
        	 typeAhead:false,
        	 hideTrigger:false,
        	 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	 listConfig: {
        		 listeners: {
        			 beforeshow: function(picker) {
        				 picker.minWidth = picker.up('combobox').getSize().width;
        			 }
        		 },
        		 loadingText: getCommonTranslation('SEARCHING'),
        		 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		 getInnerTpl: function() {
        			 return '<div class="search-item">' +
        			 '{code}'  +
        			 '</div>';
        		 }
        	 }
         },{
        	 xtype: 'textfield',
        	 fieldLabel: getCommonTranslation('INSTITUTION_NAME'),
        	 maxLength:255,
        	// allowBlank: false,
        	 hidden:true,
        	 name: 'institutionNameTextField',
        	 itemId:'institutionNameTextFieldItemId',
         },{
        	 xtype: 'textfield',
        	 fieldLabel: getCommonTranslation('STUDENT_NUMBER'),            
        	 maxLength:50,
        	// allowBlank: false,
        	 name: 'studentNumber',
        	 itemId:'studentNumberItemId',
         }]
      },{
          xtype: 'fieldcontainer',
          layout: 'hbox',
          defaults: {
              labelAlign: 'top',
              width:462
          },
          items:[{
         	 xtype: 'textarea',
         	 fieldLabel: getCommonTranslation('REMARKS'),            
         	 maxLength:255,
         	 name: 'remarks',
         	 itemId:'remarksItemId',
          }]
       }, {
           xtype: 'fieldcontainer',
           layout: 'hbox',
           defaults: {
               labelAlign: 'top',
               width:462
           },
           items:[{
               xtype: 'filefield',
               fieldLabel: getCommonTranslation('UPLOAD_TRANSCRIPTS'),
               buttonText: getPersonModuleTranslation('UPLOAD'),
               itemId: 'transcriptItemId',
               ui: 'CustomBtnSubmit',
               name: 'transcriptDoc',
               width: 256,
               disabled:true,
               labelAlign: 'top',
               allowBlank: false,
               //allowBlank:true,
               listeners: {
                   specialkey: function(me, e) {
                       if (e.getKey() == e.TAB) {
                           e.stopEvent();
                       }
                   }
               }
           }, {
               xtype: 'filefield',
               fieldLabel: getCommonTranslation('UPLOAD_CERTIFICATES'),
               buttonText: getPersonModuleTranslation('UPLOAD'),
               itemId: 'certificateItemId',
               ui: 'CustomBtnSubmit',
               name: 'certificateDoc',
               width: 256,
               labelAlign: 'top',
               disabled:true,
               allowBlank:true,
               listeners: {
                   specialkey: function(me, e) {
                       if (e.getKey() == e.TAB) {
                           e.stopEvent();
                       }
                   }
               }
           }]
        },{
            xtype: 'fieldcontainer',
            layout: 'vbox',
            defaults: {
                labelAlign: 'top',
                width:500
            },
            items:[{
				xtype: 'displayfield',
				itemId: 'transriptDownloadURL',
				//hidden:true,
				//style:{'margin-left':'10px'},
				name:'transriptDownloadURL',
				renderer:function(value,meta,record){
    				if(value==0){
    					return value;
    				}
    				else {
    					return '<a href=#>'+value+'</a>'
    				}
    			},
				listeners: {
					afterrender: function(c){
		    			c.getEl().on('click', function(e){
		    				if(e.target.tagName=='A') {
		    				var path = this.up('postschoolstudiesform').down('#transriptDownloadURL').getValue();
		    				if(!isNullOrEmpty(path)) {
		    	       		var csvForm = Ext.create('Ext.form.Panel'); 
		    	       		csvForm.getForm().submit({
		    	       			target: '_blank',
		    	       			method:'POST',
		    	       			params :{
		    	       				access_token : Ext.Ajax.defaultHeaders.access_token,
		    	       				path: path
		    	       			},
		    	       			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		    	       			url: SERVERURL.PATH_FILE_DOWNLOAD_API,
		    	       			standardSubmit :true
		    	       		});
		    				}
		    				}
		    			}, c);
		    		}
		    	}
				}, {
					xtype: 'displayfield',
					itemId: 'certificateDownloadURL',
					//hidden:true,
					//style:{'margin-left':'10px'},
					name:'certificateDownloadURL',
					renderer:function(value,meta,record){
	    				if(value==0){
	    					return value;
	    				}
	    				else {
	    					return '<a href=#>'+value+'</a>'
	    				}
	    			},
					listeners: {
						afterrender: function(c){
			    			c.getEl().on('click', function(e){
			    				if(e.target.tagName=='A') {
			    				var path = this.up('postschoolstudiesform').down('#certificateDownloadURL').getValue();
			    				if(!isNullOrEmpty(path)) {
			    	       		var csvForm = Ext.create('Ext.form.Panel'); 
			    	       		csvForm.getForm().submit({
			    	       			target: '_blank',
			    	       			method:'POST',
			    	       			params :{
			    	       				access_token : Ext.Ajax.defaultHeaders.access_token,
			    	       				path: path
			    	       			},
			    	       			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
			    	       			url: SERVERURL.PATH_FILE_DOWNLOAD_API,
			    	       			standardSubmit :true
			    	       		});
			    				}
			    				}
			    			}, c);
			    		}
			    	}
					}]
        },{
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		labelAlign: 'top',
        		width: 256
        	},
        	items:[{
        		xtype : 'nestedJsonCombo',
        		itemId : 'admDocumentStatusTranscript',
        		fieldLabel : getCommonTranslation('TRANSCRIPT_STATUS'),
        		store:Ext.create('Academia.store.common.DocumentStatusCSMStore'),
        		name: 'admDocumentStatusCSMTranscript',
        		valueField: 'id',
        		disabled:true,
        		displayField: 'value',
        		editable : false
        	},{
        		xtype: 'nestedJsonCombo',
        		fieldLabel: getCommonTranslation('CERTIFICATE_STATUS'),
        		store: Ext.create('Academia.store.common.DocumentStatusCSMStore'),
        		itemId: 'admDocumentStatusCertificate',
        		valueField: 'id',
        		disabled:true,
        		displayField: 'value',
        		name: 'admDocumentStatusCSMCertificate',
        		editable: false
        	}]
        },{
    	 xtype : 'fieldcontainer',
    	 layout : {
    		 type : 'hbox'
    	 },
    	 style:{
    		 marginTop:'22px',
    		 marginBottom:'15px'
    	 },
    	 defaults : {
    		 labelAlign : 'top'
    	 },
    	 items : [ {
    		 html: '<b><u>'+getCommonTranslation('POST_SCHOOL_EVALUATION')+'</u></b>',
    		 margin: 0,
    	 }]

       }, {
    	   xtype: 'fieldcontainer',
    	   layout: {
    		   type: 'hbox'
    	   },
    	   items : [{
    		   xtype: 'fieldcontainer',
    		   itemId:'evaluationContainerId',
    		   items:[{
    			   xtype : 'fieldcontainer',
//  			   width: '100%',
    			   itemId:'evaluationContainer',
    			   layout : 'hbox',
    			   defaults: {
    				   labelAlign: 'top',
    				   width: 256
    			   },
    			   items : [{
    				   xtype: 'customcombobox',
    				   fieldLabel: getCommonTranslation('INSTITUTION_STATUS'),
    				   store: Ext.create('Academia.store.personinfo.common.personalinfo.CSMDropDownValueStatusStore'),
    				   itemId: 'institutionStatusItemId',
    				   valueField: 'id',
    				   displayField: 'value',
    				   name: 'institutionStatus',
    				   editable: false,
    			   },{
                        xtype : 'customcombobox',
                        fieldLabel: getCommonTranslation('COUNTRY'),
    	        		hiddenName : 'countryId',
    	        		itemId: 'countryItemId',
     				    valueField: 'id',
     				    displayField: 'countryName',
    	        		store:'common.CountryStore',
    	        		name: 'country',
    	    			queryParam:'countryName',   		        						
    					forceSelection :true,
    					typeAhead : false,
    					minChars:3,
    					editable: true,
    					triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
    					triggerAction: '',
    					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    					hideTrigger:false,
    					listConfig: {
    						  listeners: {
    								beforeshow: function(picker) {
    									picker.minWidth = picker.up('combobox').getSize().width;
    								}
    							},
    			                loadingText: getCommonTranslation('SEARCHING'),
    			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			                getInnerTpl: function() {
    			                    return '<div class="search-item">' +
    			                    '{countryName}'  +
    			                    '</div>';
    			                }
    			            }			   
    			   }]
    		   }]
    	   }]
       }, {
    	   xtype: 'fieldcontainer',
    	   layout: {
    		   type: 'hbox'
    	   },
    	   items:[{
    			   xtype : 'fieldcontainer',
//  			   width: '100%',
    			   itemId:'evaluationContainer',
    			   layout : 'hbox',
    			   defaults: {
    				   labelAlign: 'top',
    				   width: 256
    			   },
    			   items : [{
    				   xtype: 'customcombobox',
    				   fieldLabel: getCommonTranslation('QUALIFICATION_STATUS'),
    				   store: Ext.create('Academia.store.personinfo.common.personalinfo.CSMDropDownValueStatusStore'),
    				   itemId: 'qualificationStatusPostSchoolItemId',
    				   valueField: 'id',
    				   displayField: 'value',
    				   name: 'qualificationStatusPostSchool',
    				   editable: false,
    			   },{
    				   xtype: 'customcombobox',
    				   fieldLabel: getCommonTranslation('RSA_NQF_COMPARABLE'),
    				   store: Ext.create('Academia.store.personinfo.common.personalinfo.CSMDropDownValueStatusStore'),
    				   itemId: 'rsaNqfComparableLevelItemId',
    				   valueField: 'id',
    				   displayField: 'value',
    				   name: 'rsaNqfComparableLevel',
    				   editable: false,
    			   }]
    		   }]
       }, {
    	   xtype: 'fieldcontainer',
    	   layout: {
    		   type: 'hbox'
    	   },
    	   items:[{
    			   xtype : 'fieldcontainer',
//  			   width: '100%',
    			   itemId:'evaluationContainer',
    			   layout : 'hbox',
    			   defaults: {
    				   labelAlign: 'top',
    				   width: 256
    			   },
    			   items : [{
    		        	 xtype: 'textfield',
    		        	 fieldLabel: getCommonTranslation('OVERALL_AVERAGE_ACHIEVED'),            
    		        	 maxLength:50,
    		        	 name: 'overallAverageAchieved',
    		        	 itemId:'overallAverageAchievedItemId',
    		         },{
    		        	 xtype: 'textfield',
    		        	 fieldLabel: getCommonTranslation('RESERCH_MODULE_GRADE'),            
    		        	 maxLength:50,
    		        	 name: 'researchModuleGrade',
    		        	 itemId:'reserchModuleGradeItemId',
    		         }]
    		   }]
       },{
    	   xtype: 'fieldcontainer',
    	   layout: {
    		   type: 'hbox'
    	   },
    	   items:[{
    			   xtype : 'fieldcontainer',
//  			   width: '100%',
    			   itemId:'evaluationContainer',
    			   layout : 'hbox',
    			   defaults: {
    				   labelAlign: 'top',
    				   width: 462
    			   },
    			   items : [{
    		         	 xtype: 'textarea',
    		         	 fieldLabel: getCommonTranslation('COMMENTARY_BY_ASSESSOR'),            
    		         	 maxLength:255,
    		         	 name: 'commentaryByAssessor',
    		         	 itemId:'commentaryAssessorItemId',
    		          }]
    		   }]
       },{
    	   xtype: 'fieldcontainer',
    	   layout: {
    		   type: 'hbox'
    	   },
    	   items:[{
    			   xtype : 'fieldcontainer',
//  			   width: '100%',
    			   itemId:'evaluationContainer',
    			   layout : 'hbox',
    			   defaults: {
    				   labelAlign: 'top',
    				   width: 256
    			   },
    			   items : [{
    				   xtype: 'customcombobox',
    				   fieldLabel: getCommonTranslation('ACADEMIC_TRANSCRIPT_VERIFICATION'),
    				   store: Ext.create('Academia.store.personinfo.common.personalinfo.CSMDropDownValueStatusStore'),
    				   itemId: 'academicTranscriptItemId',
    				   valueField: 'id',
    				   displayField: 'value',
    				   name: 'academicTranscriptVerification',
    				   editable: false,
    			   },{
    				   xtype: 'customcombobox',
    				   fieldLabel: getCommonTranslation('DEGREE_CERTIFICATE_VERIFICATION'),
    				   store: Ext.create('Academia.store.personinfo.common.personalinfo.CSMDropDownValueStatusStore'),
    				   itemId: 'degreeeCertificationItemId',
    				   valueField: 'id',
    				   displayField: 'value',
    				   name: 'degreeCertificateVerification',
    				   editable: false,
    			   }]
    		   }]
       }, {
    	 xtype : 'fieldcontainer',
    	 itemId:'employementFieldLabelItemId',
//    	 width : '100%',
    	 layout : {
    		 type : 'hbox'
    	 },
    	 style:{
    		 marginTop:'22px',
    		 marginBottom:'15px'
    	 },
    	 defaults : {
    		 labelAlign : 'top'
    	 },
    	 items : [ {
    		 html: '<b><u>'+getCommonTranslation('POST_SCHOOL_RECOMMENDATION')+'</u></b>',
    		 margin: 0,
    	 }]

       },{
    	   xtype: 'fieldcontainer',
    	   layout:'hbox',
		   defaults: {
			   labelAlign: 'top',
			   width: 256
		   },
    	   items:[{
				xtype: 'displayfield',
				name: 'progamFieldLabel',
				labelSeparator : '',
				fieldLabel: getCommonTranslation('PROGRAM')+ ': <span class="required" style="color:red"> *</span>'
			},{
				xtype: 'displayfield',
				name: 'recFieldLabel',
				labelSeparator : '',
		    	fieldLabel: getCommonTranslation('ELIGIBILITY_RECOMMENDATION')+ ': <span class="required" style="color:red"> *</span>'
			},{
				xtype: 'displayfield',
				name: 'academyLocationFieldLabel',
				itemId: 'academyLocationFieldLabelItemId',
				labelSeparator : ''
			},{
				xtype: 'displayfield',
				name: 'recommendedFieldLabel',
				itemId: 'recommendedFieldLabelItemId',
				labelSeparator : ''
			}]
       },{
    	   xtype: 'fieldcontainer',
    	   layout: {
    		   type: 'vbox'
    	   },
    	   itemId:'recommendationContainer',
    	   items:[]
       }, {
        xtype: 'fieldcontainer',
        width: '100%',     
        layout: {
 		   type: 'hbox'
 	   },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});
