/**
 * @Author Suraj Chouhan
 */
Ext.define('Academia.view.personinfo.common.pasthistory.StudentEducationHistoryDetailGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studenteducationhistorydetailgrid',
	title: getCommonTranslation('EDUCATION_DETAILS'),
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : false,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	border: true,
	autoScroll: false,
	/*defaults:{
        width:'100%'
    },
    layout:'vbox',*/
    viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
    isGridConfigurable: true,
	enableColumnHide: false,
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon',
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],

	columns: [ {
		header: getCommonTranslation('NAME_OF_INSTITUTIONS_ATTENDED'), 
		dataIndex: 'nameOfInstitutionsAttended',
		sortable: true,
		flex: .2,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){			
			if(!isNullOrEmpty(record.data.nameOfInstitutionsAttended)){
				if(record.data.nameOfInstitutionsAttended.length > 31) {
					metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(record.data.nameOfInstitutionsAttended) + '"';
					metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical; line-height: 16px;max-height: 60px;min-width: 16ch;max-width: 25ch;';
					metaData.tdCls ="student-thesis-column-cls";
				}
				return record.data.nameOfInstitutionsAttended;					
			}
		}
	}, {
		header: getCommonTranslation('HIGHEST_QUALIFICATION'), 
		dataIndex: 'highestQualification',
		sortable:true,
		flex: .2,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){			
			if(!isNullOrEmpty(record.data.highestQualification)){
				if(record.data.highestQualification.length > 31) {
					metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(record.data.highestQualification) + '"';
					metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical; line-height: 16px;max-height: 60px;min-width: 16ch;max-width: 25ch;';
					metaData.tdCls ="student-thesis-column-cls";
				}
				return record.data.highestQualification;					
			}
		}
	}, {
		header: getCommonTranslation('GRADUATION_DATE'), 
		dataIndex: 'graduationDate',
		sortable:true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header: getCommonTranslation('GRADUATION_DOCUMENT'), 
		dataIndex: 'graduationDocument',
		sortable:false,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.graduationDocument.length)) {
				if(record.data.graduationDocument.length>1) {					
					return '<a href=#>'+record.data.graduationDocument.length+'<a>';
				} else if(record.data.graduationDocument.length==1) {
					var pathSplit=record.data.graduationDocument[0].path.split('/');
		            var newPath=pathSplit[2];
					var newName=record.data.graduationDocument[0].name;
					var newValue=newName!=null?newName:newPath;
					return '<a href=#>'+newValue+'<a>';
				} 
			}                        
		}
	}, {
		header: getCommonTranslation('GRADUATION_DOCUMENT_URL'),
		dataIndex: 'graduationDocumentUrl',
		sortable:false,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.graduationDocumentUrl.length)) {
				if(record.data.graduationDocumentUrl.length>1) {					
					return '<a href=#>'+record.data.graduationDocumentUrl.length+'<a>';
				} else if(record.data.graduationDocumentUrl.length==1) {				
					var newPath=record.data.graduationDocumentUrl[0].path;
					var newName=record.data.graduationDocumentUrl[0].name;
					var newValue=!isNullOrEmpty(newName)?newName:newPath;
					return "<a href="+newPath+" target='_blank'>"+newValue;
				} 
			}                        
		} 
	  }],

    initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.addExportToolBarItems(this$);
    	this$.callParent(arguments);
    },
    buildStore: function() {
    	return Ext.create('Academia.store.personinfo.common.pasthistory.EducationHistoryDetailStore');
    }
});