/**
 * @Author Pragati Laad
 */
Ext.define('Academia.view.personinfo.common.pasthistory.StudentLearningAllowanceAddForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.studentlearningallowanceaddform',
	border : false,
    frame : false,
    plugins: "formlabelrequired",
	width:'100%',
	 items: [{
	        xtype: 'hidden',
	        itemId: 'learning_allowance_Details_hidden_field',
	        name: 'id'
	    },{
	        xtype: 'hidden',
	        itemId: 'ALID',
	        name: 'ALID'
	    },{
	 xtype: 'fieldcontainer',
     layout: 'hbox',
     defaults: {
     labelAlign: 'top',
     width: 260
    },
         items: [{
    	             xtype: 'multiselectcombofield',
    	             fieldLabel: getPersonModuleTranslation('LEARNING_ALLOWANCES'),
    	             name: 'learningAllowanceCSMMapping',
    	             itemId: 'learningAllowancesItemId',
    	             //store: 'common.LearningAllowancesCSMStore',
    	             store: Ext.create('Academia.store.common.LearningAllowancesCSMStore'),
    	             displayField: 'value',
    	             valueField: 'id',
    	             width: 260,
    	             allowBlank:false,
    	            // queryMode: 'local',
    	             typeAhead : true,
    	             forceSelection:true,
    	             triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
    	             enableKeyEvents: 'true',
    	             hideTrigger: false,
    	             listConfig: {
    	                 listeners: {
    	                     beforeshow: function(picker) {
    	                         picker.minWidth = picker.up('combobox').getSize().width;
    	                     }
    	                 },
    	                 loadingText: getCommonTranslation('SEARCHING'),
    	                 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                 getInnerTpl: function() {
    	                     return '<div class="search-item">' +
    	                     '{value}' +
    	                     '</div>';
    	                 }
    	             }
         
         },{
				xtype: 'datefield',
				name:'validForm',
				anchor: '100%',
				itemId:'validForm',
				format: 'd.m.Y',
				allowBlank:true,
				fieldLabel: getCommonTranslation('VALID_FROM'),
				listeners : {
					render : function(field) {
						return dateFormatRender(new Date());
					}
				}
			}]
} ,{
   	 xtype: 'fieldcontainer',
     layout: 'hbox',
     defaults: {
         labelAlign: 'top',
         width: 530
     },
			     items: [{
			         xtype: 'textfield',
			         fieldLabel: getCommonTranslation('DESCRIPTION_OTHER'),
			         itemId : "descriptionOtherItemId",
			         name: 'description',
			         maxLength:300,
			         hidden:true,
			         visible : false
				        }
		]
      },
     {
	 xtype: 'fieldcontainer',
     layout: 'hbox',
     defaults: {
         labelAlign: 'top',
         width: 260
     },
			     items: [{
			         xtype: 'textfield',
			         fieldLabel: getCommonTranslation('ACCOUNT_TYPE'),
			         itemId : "accountTypeItemId",
			         name: 'accountType',
			         readOnly: true
			     }
				,{
					fieldLabel: getCommonTranslation('GRANTED_BY'),  
	                xtype: 'customcombobox',
	                name: 'grantedby',
	                itemId: 'grantedByItemId',                    
	                store: 'common.StudentGrantByStore',
	                valueField: 'id',
	                displayField: 'value',
	                editable: false,                                       
	                triggerAction: 'all',
	                queryMode: 'remote',
	                forceSelection: true
		        },]
},
{
	 xtype: 'fieldcontainer',
     layout: 'hbox',
     defaults: {
         labelAlign: 'top',
         width: 260
     },
     items: [{
    	 xtype: 'multiselectcombofield',
    	             fieldLabel: getCommonTranslation('APPLIES_TO'),
    	             name: 'appliesTo',
    	             itemId: 'appliesToItemId',
    	             store: Ext.create('Academia.store.organization.academylocations.ActiveAcademyLocationStore'),
    	             displayField: 'value',
    	             valueField: 'id',
    	             width: 260,
    	             queryMode: 'remote',
    	             typeAhead : false,
    	             forceSelection:true,
    	             triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
    	             enableKeyEvents: 'true',
    	             hideTrigger: false,
    	             listConfig: {
    	                 listeners: {
    	                     beforeshow: function(picker) {
    	                         picker.minWidth = picker.up('combobox').getSize().width;
    	                     }
    	                 },
    	                 loadingText: getCommonTranslation('SEARCHING'),
    	                 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                 getInnerTpl: function() {
    	                     return '<div class="search-item">' +
    	                     '{value}' +
    	                     '</div>';
    	                 }
    	             }
     }
				,{
						xtype: 'datefield',
						name:'dateModified',
						itemId:'dateModified',
						readOnly: true,
						format: 'd.m.Y',
						fieldLabel: getCommonTranslation('DATE_MODIFIED'),
						listeners : {
							render : function(field) {
								return dateFormatRender(new Date());
							}
						}
				},]
},
		{
				xtype:'fieldcontainer',
		    	width:'auto',
				layout : 'hbox',
				items: [{
		            xtype: 'button',
		            text: getCommonTranslation('SAVE'),
		            itemId: 'submitButtonId',
		            buttonAlign: 'right',
		            ui: 'CustomBtnSubmit',
		            scale: CONSTANTS.BUTTONSIZE,
		            formBind: true
		        },{
		            xtype: 'button',
		            text: getCommonTranslation('CANCEL'),
		            ui: 'CustomBtnCancel',
		            itemId: 'cancelButtonId',
		            scale: CONSTANTS.BUTTONSIZE
		        }]
		    }]
});