/**
 * @author priyanshi Sharma
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.FinancialSupportDetailsWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.financialsupportdetailswin',
	title: getPersonModuleTranslation('FINANCIAL_SUPPORT'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		plugins : "formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype:'hidden',
			itemId:'recordId',
			name:'recordId'
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'customcombobox',
				editable:false,
				forceSelection: true,
			},
			items:[{
				name: 'financialSupportProgram',
				itemId:'financialSupportProgramId',
				store: 'personinfo.common.paymentandrefund.FinancialSupportProgramStore',
				fieldLabel: getCommonTranslation('PROGRAM'),
				allowBlank:false,
				valueField: 'programId',
				displayField: 'programCodeName',
				listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						//picker.minWidth = picker.up('combobox').getSize().width;
    						var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    			}
			},{
				name: 'financialSupportBatch',
				itemId:'financialSupportBatchId',
				store:'personinfo.common.paymentandrefund.FinancialSupportBatchStore',
				valueField: 'batchId',
				displayField: 'batchName',
				allowBlank:false,
				disabled:true,
				fieldLabel: getCommonTranslation('BATCH'),
				listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						//picker.minWidth = picker.up('combobox').getSize().width;
    						var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    			}
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'customcombobox',
				editable:false,
				forceSelection: true,
			},
			items:[{
				name: 'financialSupportPeriod',
				itemId:'financialSupportPeriodId',
				store: 'personinfo.common.paymentandrefund.FinancialSupportPeriodStore',
				fieldLabel: getCommonTranslation('PERIOD'),
				valueField: 'periodId',
				displayField: 'periodName',
				allowBlank:false,
				disabled:true,
				listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						//picker.minWidth = picker.up('combobox').getSize().width;
    						var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    			}
			},{
				name: 'accessAndParticipationFlag',
				itemId:'accessAndParticipationFlagId',
				store:'personinfo.common.paymentandrefund.AccessAndParticipationFlagStore',
				valueField: 'id',
				displayField: 'value',
				fieldLabel: getCommonTranslation('ACCESS_AND_PARTICIPATION_FLAG'),
				listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						//picker.minWidth = picker.up('combobox').getSize().width;
    						var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    			}
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'numberfield',
				name: 'financialSupportAmount',
				itemId:'financialSupportAmountId',
				hideTrigger:true,
				maxLength:10,
				minValue:0,
				allowExponential:false,
				fieldLabel: getCommonTranslation('FINANCIAL_SUPPORT_AMOUNT'),
				listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						//picker.minWidth = picker.up('combobox').getSize().width;
    						var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    			}
			},{
				xtype: 'customcombobox',
				editable:false,
				forceSelection: true,
				name: 'financialSupportType',
				itemId:'financialSupportTypeId',
				store:'personinfo.common.paymentandrefund.FinancialSupportTypeStore',
				valueField: 'id',
				displayField: 'value',
				fieldLabel: getCommonTranslation('FINANCIAL_SUPPORT_TYPE'),
				listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						//picker.minWidth = picker.up('combobox').getSize().width;
    						var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    			}
			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'financialSupportSave',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'financialSupportCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});
