/**
 * This view is used for the student, faculty payment received history grid.
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.PaymentReceivedHistoryGrid', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.paymentreceivedhistorygrid',
	title: getCommonTranslation('RECEIPTS'),
	border: true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig: {
		stripeRows: true
	},
	selType : 'checkboxmodel',
	selModel : {
		mode : 'MULTI',
		showHeaderCheckbox : true,
		allowDeselect : true,
		checkOnly : true,
		renderer : function(value, metaData, record, rowIndex,
				colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix
			+ 'grid-cell-special ' + baseCSSPrefix
			+ 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix
			+ 'grid-row-checker">&#160;</div>';
		}
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],
	initComponent: function() {
		var this$ = this;
		this$.addExportToolBarItems(this$,false);
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			columns: [{
				header: getCommonTranslation('RECEIPT_DATE'),
				dataIndex: (this$.personType=='STUDENT')?'paymentDate':'transactionDate',
						flex: .2,
						renderer:function(value,meta){
							if(!isNullOrEmpty(value)) {
								return dateRender(value);
							}                        
						},
						summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){

							if(portalId==1){
								if(!isNullOrEmpty(store.data.items[0].data.baseCurrencyId)) {
									return getFeeAndPaymentCommonTranslation('TOTAL')+" ("+"In "+store.data.items[0].data.baseCurrencyName+")";
								} else {
									return getFeeAndPaymentCommonTranslation('TOTAL');
								}
							}else{
								if(!isNullOrEmpty(store.data.items[0].data.baseCurrencyId)) {
									return getFeeAndPaymentCommonTranslation('TOTAL');
								}
							}

						}
			}, {
				header: getCommonTranslation('RECEIPT_NUMBER'),
				dataIndex: 'receiptNo',
				sortable: true,
				flex: .2
			}, {
				header: getCommonTranslation('RECEIPT_AMOUNT'),
				dataIndex: (this$.personType=='STUDENT')?'feeAmount':'amount',
						flex: .2,
						summaryType: 'sum',
						renderer:function(value, metaData, record, row, col, store, gridView){
							if(!isNullOrEmpty(value)) {
								return currencyRenderer(value,record.get("currencyId"));
							}
						},
						summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
							if(portalId ==1){
								if(store.data.items[0].data.baseCurrencyId==null){
									return currencyRenderer(value,record.get("currencyId"));
								}
								return " ";
							}else{
								//return Ext.util.Format.currency(value,'',record.get("currencyId"),false);
								return currencyRenderer(value,store.data.items[0].data.currencyId);
							}
						}
						/*renderer:function(value, metaData, record, row, col, store, gridView){
    				if(!isNullOrEmpty(value)) {
    					return currencyRenderer(value,record.get("currencyId"));
    				}
    			},
    			summaryType: 'sum',
    			align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
    			summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
    				return  value;
    			}*/,
			},
			{
				header : getCommonTranslation('CURRENCY_EXCHANGE_RATE'),
				dataIndex : 'currencyExchangeRate',
				flex : 0.3
			}, {
				header : getCommonTranslation('CONVERTED_AMOUNT'),
				dataIndex : 'convertedAmount',
				flex : 0.2,
				summaryType: 'sum',
				renderer:function(value, metaData, record, row, col, store, gridView){
					if(!isNullOrEmpty(value)){
						return currencyRenderer(value,record.get("baseCurrencyId"));
					}
				},
				summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
					return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
				}
				/*renderer:function(value, metaData, record, row, col, store, gridView){
	    				if(!isNullOrEmpty(value)) {
	    					return currencyRenderer(value,record.get("baseCurrencyId"));
	    				}
	    			},
		    		summaryType: 'sum',
	                align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	                summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
	                	return  value;
	                }*/,
			},
			{
				header: getCommonTranslation('RECEIPT_TYPE'),
				dataIndex: 'raiseBillType',
				flex: .2,
				renderer:function(value,meta){
					if(!isNullOrEmpty(value)) {
						return getCommonTranslation(value);
					}                        
				}
			}, {
				header: getCommonTranslation('RECEIPT_FORM'),
				dataIndex: 'billType',
				flex: .2,
				renderer:function(value,meta){
					if(!isNullOrEmpty(value)) {
						return getCommonTranslation(value);
					}                        
				}
			},{
				header: getCommonTranslation('RECEIPT_MODE'),
				dataIndex: 'receiptType',
				flex: .2,
				renderer:function(value,meta){
					if(!isNullOrEmpty(value)) {
						return getCommonTranslation(value);
					}                        
				}
			}, {
				header: getCommonTranslation('VOUCHER_MODE'),
				dataIndex: 'voucherMode',
				flex: .2,
				renderer:function(value,meta){
					if(!isNullOrEmpty(value)) {
						return getCommonTranslation(value);
					}                        
				}
			},  {
				header: getCommonTranslation('PENDING_SETTLEMENT'),
				dataIndex: (this$.personType=='STUDENT')?'pendingAmount':'adjustedAmount',
				flex: 0.2,
				summaryType: 'sum',
				//   align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
				summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
					if(portalId ==1){
						return " ";
					}else{
						return  value;
					}
				}
			},{
				header : getCommonTranslation('SETTLEMENT_STATUS'),
				dataIndex : 'receiptStatus',
				flex : .2,
				renderer : function(value, metaData, record,
						rowIndex, colIndex, view) {
					metaData.style = "white-space: normal;";
					return getCommonTranslation(value);
				}
			},{
				header: getCommonTranslation('ADJUSTMENT_DETAILS'),
				dataIndex: 'adjustment',
				flex: .2,
				align : 'center',
				renderer: function(value){
					return '<a href="#">'+getPersonModuleTranslation('VIEW')+'</a>';
				}
			}, {
				header: getCommonTranslation('INSTRUMENT_DETAILS'),
				dataIndex: 'instrument',
				flex: .2,
				align : 'center',
				renderer: function(obj, meta, record, rowIndex){
					if(record.data.voucherMode === "BANK") {
						return '<a href="#">'+getPersonModuleTranslation('VIEW')+'</a>';
					}
				}	
			},{
				header : getCommonTranslation('SINGLE_FEE_HEAD'),
				dataIndex : 'singleFeeHeadName',
				flex : .2,
				hidden : true,
				renderer:function(value,meta,record){
					if(!isNullOrEmpty(value)) {
						return getCommonTranslation(value);
					}                    
				} 
			}],
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.personinfo.common.paymentandrefund.PaymentReceivedHistoryStore');
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnPrint',
		disabled : true,
		icon: 'resources/images/print1.png',
		tooltip: getFeeAndPaymentCommonTranslation('Print')
	}]
});