/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.PaymentSummaryWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.paymentsummarywin',
	title:getExaminationTranslation('Pre-Payment Summary'),
	frame: true,
	autoScroll:false,
	modal:true,
	width: '40%',
	height:'45%',
	closable:false,
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype:'displayfield',
				name:'name',
				itemId:'name',
				fieldLabel:getCommonTranslation('NAME')
			},{
				xtype:'displayfield',
				name:'email',
				itemId:'email',
				fieldLabel:getCommonTranslation('EMAIL')
			}]

		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype:'displayfield',
				name:'mobileNo.',
				itemId:'mobileNo',
				fieldLabel:getCommonTranslation('CELL_NO')
			},{
				xtype:'displayfield',
				name:'amount',
				itemId:'amount',
				fieldLabel:getCommonTranslation('TOTAL_AMOUNT')
			}]

		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			items:[ {
				xtype: 'checkboxfield',
				itemId: 'onlinePaymentTermCondCheck',
			     name: 'onlinePaymentTermCondCheck',
				inputValue: true,
				uncheckedValue: false
			},{
				xtype:'displayfield',
				width:'100%',
				value:"<a href='#'>"+getCommonTranslation('I_HAVE_READ_THE_TERMS_AND_CONDITIONS_REGARDING_ONLINE_PAYMENT')+"</a>",
				itemId:'onlinePaymentConditionMsg'
			}]
		},{
			xtype: 'fieldcontainer',
			layout:'hbox',
			cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				itemId:'payNow',
				text: getCommonTranslation('Pay Now'),
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			}, {
				xtype: 'button',
				text: getCommonTranslation('OK'),
				itemId:'okBtn',
				ui: 'CustomBtnCancel',
				hidden:true,
				scale: CONSTANTS.BUTTONSIZE
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId:'cancelBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});