/**
 * This view is used for the applicant for showing his receipts
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.ReceiptGridForApplicant', {
	extend: 'Ext.grid.Panel',
//	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.receiptgridforapplicant',
	title: getCommonTranslation('RECEIPTS'),
	border: true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig: {
		stripeRows: true
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],
	initComponent: function() {
		var this$ = this;
//		this$.addExportToolBarItems(this$,false);
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			columns: [{
				header: getCommonTranslation('ACADEMY_LOCATION'),
				dataIndex: 'academyLocationName',
				flex: .2,
				renderer:function(value,meta){
					if(!isNullOrEmpty(value)) {
						return getCommonTranslation(value);
					}                        
				}
			},{
				header: getCommonTranslation('RECEIPT_DATE'),
				dataIndex: (this$.personType=='STUDENT')?'paymentDate':'transactionDate',
						flex: .2,
						renderer:function(value,meta){
							if(!isNullOrEmpty(value)) {
								return dateRender(value);
							}                        
						},
						summaryRenderer: function(value, summaryData, dataIndex) {
							return getFeeAndPaymentCommonTranslation('TOTAL');
						}
			}, {
				header: getCommonTranslation('RECEIPT_NUMBER'),
				dataIndex: 'receiptNo',
				sortable: true,
				flex: .2
			}, {
				header: getCommonTranslation('RECEIPT_AMOUNT'),
				dataIndex: (this$.personType=='STUDENT')?'feeAmount':'amount',
				flex: .2,
				renderer:function(value, metaData, record, row, col, store, gridView){
					if(!isNullOrEmpty(value)) {
						return currencyRenderer(value,record.get("currencyId"));
					}
				},
				summaryType: 'sum',
				align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
				summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
					return  value;
				}
			}, {
				header: getCommonTranslation('RECEIPT_TYPE'),
				dataIndex: 'raiseBillType',
				flex: .2,
				renderer:function(value,meta){
					if(!isNullOrEmpty(value)) {
						return getCommonTranslation(value);
					}                        
				}
			},{
				header: getCommonTranslation('RECEIPT_MODE'),
				dataIndex: 'receiptType',
				flex: .2,
				renderer:function(value,meta){
					if(!isNullOrEmpty(value)) {
						return getCommonTranslation(value);
					}                        
				}
			}, {
				header: getCommonTranslation('VOUCHER_MODE'),
				dataIndex: 'voucherMode',
				flex: .2,
				renderer:function(value,meta){
					if(!isNullOrEmpty(value)) {
						return getCommonTranslation(value);
					}                        
				}
			},{
				header: getCommonTranslation('STATUS'),
				dataIndex: 'status',
				flex: .2,
				renderer:function(value,meta){
					if(!isNullOrEmpty(value)) {
						return getCommonTranslation(value);
					}                        
				}
			},{
				header: getCommonTranslation('ADJUSTMENT_DETAILS'),
				dataIndex: 'adjustment',
				flex: .2,
				align : 'center',
				renderer: function(value){
					return '<a href="#">'+getPersonModuleTranslation('VIEW')+'</a>';
				}
			}, {
				header: getCommonTranslation('INSTRUMENT_DETAILS'),
				dataIndex: 'instrument',
				flex: .2,
				align : 'center',
				renderer: function(obj, meta, record, rowIndex){
					if(record.data.voucherMode == 'CASH') {
						return getTranslation('');
					} else {
						return '<a href="#">'+getPersonModuleTranslation('VIEW')+'</a>';
					}	
				}
			},{
				header : getCommonTranslation('SINGLE_FEE_HEAD'),
				dataIndex : 'singleFeeHeadName',
				flex : .2,
				hidden : true,
				renderer:function(value,meta,record){
					if(!isNullOrEmpty(value)) {
						return getCommonTranslation(value);
					}                    
				} 
			}],
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.feeandpayment.receipts.ReceiptHeaderForApplicant');
	},
	tbar: ['->',{
		xtype: 'button',
		itemId: 'btnPrint',
		disabled : true,
		icon: 'resources/images/print1.png',
		tooltip: getFeeAndPaymentCommonTranslation('Print')
//		hidden:true
	}]
});