/**
 * 
 * This component is used for to show Address Details Dialog Box 
 */

Ext.define('Academia.view.personinfo.common.personalinfo.AddressFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.addressformwindow',
    modal: true,
    resizable: false,
    maxHeight:600,
    autoScroll: true,
    frame: true,
    title: getPersonModuleTranslation('ADDRESS_DETAILS'),
    formAddressData : {},
    margin: 0,
    items: [{
        xtype: 'dynamicfieldformwin',
        standardSubmit: false,
        plugins : "formlabelrequired",
        items: [{
            xtype: 'addressfieldsform',
            itemId:'personAddressFieldsForm'
        },  {
        	xtype:'fieldcontainer',
        	width:'100%',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'),
                itemId: 'submitButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind : true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE

            }]
        }]
    }, {
        xtype: 'hidden',
        name: 'addressCategory',
        value: 'ORG'
    }],
    getFormAddressData : function(){
    	return this.formAddressData;
    },
    setFormAddressData : function(formAddressData){
    	this.formAddressData =  formAddressData;
    },
 // BEGIN SCROLL-SAVING WORKAROUND CODE    
    onRender : function() {
        this.callParent(arguments);
        this.body.on('scroll', this.saveScroll, this);
    },
    
    afterComponentLayout : function() {
        this.callParent(arguments);
        this.restoreScroll();
    },
    
    saveScroll : function() {
        this.savedScroll = this.body.getScroll();
    },
    
    restoreScroll : function() {
        var savedScroll = this.savedScroll || {};  // empty obj for when no scroll has occurred before this method is executed
        this.body.scrollTo('top', savedScroll.top || 0);
    }
    // END SCROLL-SAVING WORKAROUND CODE
});