/**
 * @Author Suraj Chouhan
 */
Ext.define('Academia.view.personinfo.common.personalinfo.ApplicantInsuranceDetailsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.applicantinsurancedetailsgrid',
	title: getCommonTranslation('INSURANCE'),
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : false,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	border: true,
    viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
    isGridConfigurable: true,
	enableColumnHide: false,
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon',
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns: [ {
		header: getCommonTranslation('HEALTH_INSURANCE_CONFIRMED'), 
		dataIndex: 'healthInsuranceConfirmed',
		sortable: true,
		flex: .2,
		renderer:function(value, meta, record) {
//			console.log(record, '=record')
			return record.data.healthInsuranceConfirmed == true ? 'True':'False';
		}
	}, {
		header: getCommonTranslation('SCHOOL_INSURANCE_TYPE'), 
		dataIndex: 'schoolInsuranceTypeValue',
		sortable:true,
		flex: .2
	}, {
		header: getCommonTranslation('VALID_FROM'), 
		dataIndex: 'validFrom',
		sortable:true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header: getCommonTranslation('VALID_TO'), 
		dataIndex: 'validTo',
		sortable:true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header: getCommonTranslation('NAME_OF_INSURANCE_COMPANY'), 
		dataIndex: 'nameOfInsuranceCompany',
		sortable:true,
		flex: .2

	}, {
		header: getCommonTranslation('POLICY_NUMBER'), 
		dataIndex: 'policyNumber',
		sortable:true,
		flex: .2

	}, {
		header: getCommonTranslation('SCHOOL_INSURANCE_CARD_RECEIVED'), 
		dataIndex: 'schoolInsuranceCardReceived',
		sortable:true,
		flex: .2,
		 renderer:function(value, meta, record){
	            if(!isNullOrEmpty(value)) {
	                return record.data.schoolInsuranceCardReceived==false?'False':'True';
	            }                        
	        }
	}, {
		header: getCommonTranslation('RECEIVED_DATE'), 
		dataIndex: 'receivedDate',
		sortable:true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header: getCommonTranslation('REAMRK'), 
		dataIndex: 'remarks',
		sortable:true,
		flex: .2

	},{
		header: getCommonTranslation('HEALTH_INSURANCE_DOCUMENT'), 
		dataIndex: 'applicantInsuranceDocuments',
		sortable:false,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.applicantInsuranceDocuments.length)) {
				if(record.data.applicantInsuranceDocuments.length>1) {					
					return '<a href=#>'+record.data.applicantInsuranceDocuments.length+'<a>';
				} else if(record.data.applicantInsuranceDocuments.length==1) {
					var pathSplit=record.data.applicantInsuranceDocuments[0].path.split('/');
		            var newPath=pathSplit[2];
					var newName=record.data.applicantInsuranceDocuments[0].name;
					var newValue=newName!=null?newName:newPath;
					return '<a href=#>'+newValue+'<a>';
				} 
			}                        
		}
	}, {
		header: getCommonTranslation('HEALTH_INSURANCE_DOCUMENT_URL'),
		dataIndex: 'applicantInsuranceDocumentUrls',
		sortable:false,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.applicantInsuranceDocumentUrls.length)) {
				if(record.data.applicantInsuranceDocumentUrls.length>1) {					
					return '<a href=#>'+record.data.applicantInsuranceDocumentUrls.length+'<a>';
				} else if(record.data.applicantInsuranceDocumentUrls.length==1) {			
					var newPath=record.data.applicantInsuranceDocumentUrls[0].path;
					var newName=record.data.applicantInsuranceDocumentUrls[0].name;
					var newValue=!isNullOrEmpty(newName)?newName:newPath;
					return "<a href="+newPath+" target='_blank'>"+newValue;
				} 
			}                        
		} 
	}],
    initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.addExportToolBarItems(this$);
    	this$.callParent(arguments);
    },
    buildStore: function() {
    	return Ext.create('Academia.store.personinfo.common.personalinfo.ApplicantInsuranceDetailStore');
    }
});