/**
 * @Author Vyabha Thakur 
 */
Ext.define('Academia.view.personinfo.common.personalinfo.ApplicantPassportGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.applicantpassportgrid',
	title: getPersonModuleTranslation('PASSPORT_DETAILS'),
	border: true,
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : false,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	 viewConfig: {
	        stripeRows: CONSTANTS.STRIPEROWS
	 },
	 isGridConfigurable: true,
	 enableColumnHide: false,
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns: [{
		header: getCommonTranslation('PASSPORT_NUMBER'), 
		dataIndex: 'passportNumber',
		sortable:true,
		flex: .2
	},{
		header: getCommonTranslation('PASSPORT_NAME'), 
		dataIndex: 'passportName',
		sortable:true,
		flex: .2,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
        	if(!isNullOrEmpty(value)){
				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
		    	metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 16px;max-height: 60px;min-width: 16ch;max-width: 17ch;';
				metaData.tdCls ="student-thesis-column-cls";
	            return value;
			}	
		}
	}, {
		header: getCommonTranslation('COUNTRY_OF_ISSUE'), 
		dataIndex: 'countryOfIssueValue',
		sortable: true,
		flex: .2
	}, {
		header: getCommonTranslation('PASSPORT_EXPIRATION_DATE'), 
		dataIndex: 'passportExpirationDate',
		sortable:true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header: getCommonTranslation('IS_PRIMARY'), 
		dataIndex: 'isPrimary',
		sortable:true,
		flex: .2,
		 renderer:function(value, meta, record){
	            if(!isNullOrEmpty(value)) {
	                return record.data.isPrimary==false?'False':'True';
	            }                        
	        }
	}, {
		header: getCommonTranslation('COPY_OF_PASSPORT'),
		dataIndex: 'copyOfPassport',
		sortable:true,
		flex: .2,
		renderer:function(value, meta, record){
			console.log('record='+record)
			if(!isNullOrEmpty(record.data.copyOfPassports.length)) {
				if(record.data.copyOfPassports.length>1) {					
					return '<a href=#>'+record.data.copyOfPassports.length+'<a>';
				} else if(record.data.copyOfPassports.length==1) {
					var pathSplit=record.data.copyOfPassports[0].path.split('/');
                    var newPath=pathSplit[2];
					var newName=record.data.copyOfPassports[0].name;
					var newValue=!isNullOrEmpty(newName)?newName:newPath;
					return '<a href=#>'+newValue+'<a>';
				} 
			}                          
		}
	}, {
		header: getCommonTranslation('COPY_OF_PASSPORT_URL'), 
		dataIndex: 'copyOfPassportUrl',
		sortable:true,
		flex: .2,
		renderer:function(value, meta, record){
			console.log('record='+record)
			if(!isNullOrEmpty(record.data.copyOfPassportUrls.length)) {
				if(record.data.copyOfPassportUrls.length>1) {					
					return '<a href=#>'+record.data.copyOfPassportUrls.length+'<a>';
				} else if(record.data.copyOfPassportUrls.length==1) {
					var newPath=record.data.copyOfPassportUrls[0].path;
					var newName=record.data.copyOfPassportUrls[0].name;
					var newValue=!isNullOrEmpty(newName)?newName:newPath;
					return "<a href="+newPath+" target='_blank'>"+newValue;
				} 
			}                        
		}
	}, {
        header:getCommonTranslation('FILE_MODIFIED_DATE'),
        dataIndex: 'fileModifiedDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }],
    initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.addExportToolBarItems(this$);
    	this$.callParent(arguments);
    },
    buildStore: function() {
    	return Ext.create('Academia.store.personinfo.common.personalinfo.ApplicantPassportStore');
    }
});