/**
 * @author Vidhi Shah
 */
Ext.define('Academia.view.personinfo.common.personalinfo.ApplicantPermitDocumentGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.applicantpermitdocumentgrid',
    store : 'personinfo.common.personalinfo.ApplicantPermitDocumentGridStore',
	border: true,
	refreshStoreData:true,
	autoScroll: false,
	isFixHeightGrid: true,
	isFixWidthColums: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar: [
	{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH		
	
	}],
	columns :[{
		header : getCommonTranslation('DOCUMENT_NAME'),
		dataIndex : 'documentName',
		flex:1,
		sortable: false,
		renderer:function(value, metaData, record){
			if(record){
				var pathSplit=record.data.path.split('/');
	            var newPath=pathSplit[2];
				var newvalue=!isNullOrEmpty(value)?value:newPath;
				return "<a href='#'>"+newvalue+"</a>";
			}
		}
	}]
});

