Ext.define('Academia.view.personinfo.common.personalinfo.FeePayerDetailCardTpl', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.feepayerdetailcardtpl',
    title: '',
	flex: 1,
	layout: {
	    type: 'vbox',
	    align: 'stretch'
	},
    columnWidth:0.5,
    border: true,
    height: 245,
    cls: 'parentgaurdiancards',
    collapsible: true,
    collapsed: true,
	items: [
		{
			xtype: 'panel',
			layout: 'hbox',
	    	flex: 1,
	    	cls: 'pgCardLayoutUprPnl',
	        style: 'height:130px !important',
			items:[{
		        xtype: 'hidden',
		        name: 'feePayerDetail',
		        itemId: 'feePayerDetail'
			},{
				xtype: 'fieldcontainer',
				flex: 8,
				defaults: {
					labelWidth: 125,
					labelStyle: 'white-space: nowrap;width:auto'
				},
				items:[{
					xtype: 'displayfield',
					fieldLabel: getPersonModuleTranslation('FPD_FEE_PAYER_TYPE'),
					value: '',
					//labelWidth: 70,
					name: 'fpTypeField',
					//fieldStyle: 'text-transform: capitalize;font-weight: bold;margin-top: -1px !important;',
					listeners: {
			            change: function(df, newValue, oldValue, eOpts) {
			            	Ext.query('#'+df.el.dom.id+'-bodyEl')[0].title = newValue;
			            }
			        },
			        renderer: function(val) {
			            var value = '';
			            if (val == 'PERSON') {
			                value = getPersonModuleTranslation('FPD_PERSON');
			            } else if (val == 'CORPORATE') {
			                value = getPersonModuleTranslation('FPD_CORPORATE');
			            }
			            return value;
			        }
				},
				{
					xtype: 'displayfield',
					fieldLabel: getPersonModuleTranslation('FPD_FEE_PAYER_NAME'),
					value: '',
					cls:'fullLengthFieldDataCls',
					//labelWidth: 70,
					name: 'fpNameField',
					listeners: {
			            change: function(df, newValue, oldValue, eOpts) {
			            	Ext.query('#'+df.el.dom.id+'-bodyEl')[0].title = newValue;
			            }
			        }
				},
				{
					xtype: 'displayfield',
					fieldLabel: getCommonTranslation('MOBILE_NO'),
					value: '',
					//labelWidth: 70,
					name: 'fpMobileNoField',
					listeners: {
			            change: function(df, newValue, oldValue, eOpts) {
			            	Ext.query('#'+df.el.dom.id+'-bodyEl')[0].title = newValue;
			            }
			            
			        },renderer: function(val) {
			            return val.replace(null+' ' ,'');
			        }
				},
				{
					xtype: 'displayfield',
					fieldLabel: getAdmissionTranslation('EMAIL_ADDRESS'),
					value: '',
					//labelWidth: 70,
					name: 'fpEmailField',
					listeners: {
			            change: function(df, newValue, oldValue, eOpts) {
			            	Ext.query('#'+df.el.dom.id+'-bodyEl')[0].title = newValue;
			            }
			        }
				},
				{
					xtype: 'displayfield',
					fieldLabel: getCommonTranslation('DOCUMENTS'),
					value: '',
					//labelWidth: 70,
					name: 'fpDocumentsField',
					renderer:function(value,meta,record){
        				if(value==0){
        					return value;
        				}
        				else {
        					return '<a href=#>'+value+'</a>'
        				}
        			}
				}]
			}]
		},
		{
			xtype: 'panel',
	    	flex: 1,
	    	cls: 'pgCardLayoutBtnPnl',
	    	layout: 'hbox',
	    	items: [{
	            xtype: 'button',
	            text: getCommonTranslation('EDIT'),
	            itemId: 'edit_FP_ItemId',
	            buttonAlign: 'left',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE
	        },{
	            xtype: 'button',
	            text: getCommonTranslation('VIEW'),
	            itemId: 'view_FP_ItemId',
	            buttonAlign: 'left',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE
	        },{
	            xtype: 'button',
	            text: getCommonTranslation('DELETE'),
	            itemId: 'delete_FP_ItemId',
	            buttonAlign: 'left',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE
	        }]
		}
	]
});