/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.personinfo.common.personalinfo.FeePayerDetailDocumentGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.feepayerdetaildocumentgrid',
    store: 'personinfo.common.personalinfo.FeePayerDetailDocumentStore',
    border: true,
    autoScroll: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    tbar: [/*{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }*/],
    columns: [{
        header: getPersonModuleTranslation('DOCUMENTS_TYPE'),
        dataIndex: 'id',
        flex: .5,
        sortable: true,
        renderer: function(value, metaData, record) {
            var id = record.data.id;
            if (!isNullOrEmpty(id)) {
            	if(id == 1) {
            		return getPersonModuleTranslation('FPD_FEE_PAYER_ID');
            	} else if(id == 2) {
            		return getPersonModuleTranslation('FPD_FEE_PAYER_LATEST_PAYSLIP');
            	} else if(id == 3) {
            		return getPersonModuleTranslation('COMPANY_SPONSOR_LETTER');
            	} else{
            		return getPersonModuleTranslation('FPD_FEE_PAYER_PROOF_OF_ACCOUNT');
            	}
                return '';
            }
            return '';
        }
    }, {
        header: getCommonTranslation('DOCMENT_NAME'),
        dataIndex: 'documentName',
        flex: 1,
        renderer: function(value, rec) {
            var id = rec.record.data.id;
            if (id != "" && id != undefined) {
                return '<a href="#">' + value + '</a>';
            } else {
                return value;
            }
        }
    }]
});