/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.personinfo.common.personalinfo.FeePayerDetailForm', {
    //extend: 'Ext.form.Panel',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	customFieldEntity:CONSTANTS.FEE_PAYER_DETAIL_CD,
	alias: 'widget.feepayerdetailform',
    border: false,
    frame: false,
    style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
    plugins: "formlabelrequired",
    cls: 'x-form-fixed-footer-parent',
    padding: '0 0 0 16',
    items: [{
        xtype: 'hidden',
        name: 'module',
        value: 'FeePayerDetail'
    }, {
        xtype: 'hidden',
        name: 'feePayerIdUploadPath'
    }, {
        xtype: 'hidden',
        name: 'feePayerProofOfAccountUploadPath'
    },{
        xtype: 'hidden',
        name: 'feePayerLatestPayslipUploadPath'
    },{
        xtype: 'hidden',
        name: 'companySponsorLetterUploadPath'
    }, {
        xtype: 'hidden',
        itemId: 'idItemId',
        name: 'id'
    },  {
        xtype: 'hidden',
        itemId: 'documentIdItemId',
        name: 'documentId'
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 321
        },
        layout: 'hbox',
        items: [{
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: 'vbox',
            defaults: {
                labelAlign: 'top',
            },
            items: [{
                xtype: 'radiogroup',
                itemId: 'payerTypeItemId',
                fieldLabel: getPersonModuleTranslation('FPD_PAYER_TYPE'),
                width: 355,
                height: 65,
                style: {
                    marginTop: '5px'
                },
                defaults: {
                    flex: .1
                },
                items: [{
                    boxLabel: getPersonModuleTranslation('FPD_PERSON'),
                    name: 'payerType',
                    inputValue: 'PERSON',
                    checked: true

                }, {
                    boxLabel: getPersonModuleTranslation('FPD_CORPORATE'),
                    name: 'payerType',
                    inputValue: 'CORPORATE'
                },{
                    boxLabel: getPersonModuleTranslation('FPD_STUDENT'),
                    name: 'payerType',
                    inputValue: 'STUDENT',
                    hidden:true
                    
                }]
            }]
        },
        {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: 'hbox',
            itemId: 'empOfTheOrgContainerItemId',
            defaults: {
                labelAlign: 'top',
            },
            items: [{
                xtype: 'fieldcontainer',
                width: 'auto',
                layout: 'vbox',
                defaults: {
                    labelAlign: 'top',
                },
                items: [/*{
                    xtype: 'label',
                    itemId: 'empOfTheOrgLabelItemId',
                    text: getPersonModuleTranslation('FPD_EMPLOYEE_OF_THE_ORGANIZATION'),
                    style: {
                        marginTop: '5px'
                    },
                    width: 256
                },*/ {
                    xtype: 'radiogroup',
                    itemId: 'empOfTheOrgItemId',
                    fieldLabel: getPersonModuleTranslation('FPD_EMPLOYEE_OF_THE_ORGANIZATION'),
                    width: 230,
                    height: 65,
                    defaults: {
                        flex: .1
                    },
                    items: [{
            			boxLabel: getPersonModuleTranslation('YES'),
            			itemId: 'employeeOfOrganizationyes',
            			name: 'employeeOfOrganization',
            			inputValue: true
            		//	checked: true
            		}, {
            			boxLabel: getPersonModuleTranslation('NO'),
            			itemId: 'employeeOfOrganizationno',
            			name: 'employeeOfOrganization',
            			inputValue: false,
            			checked: true
            		}]
                }]
            }, {
                xtype: 'fieldcontainer',
                width: 'auto',
                layout: 'vbox',
                defaults: {
                    labelAlign: 'top',
                },
                items: [/*{
                    xtype: 'label',
                    text: getPersonModuleTranslation('FPD_EMPLOYEE_ID'),
                    style: {
                        marginTop: '5px'
                    },
                    width: 256
                },*/ {
                    xtype: 'textfield',
                    name: 'employeeId',
                    itemId: 'employeeIdItemId',
                    fieldLabel: getPersonModuleTranslation('FPD_EMPLOYEE_ID'),
                    allowBlank: true,
                    maxLength: 100,
                    labelStyle: 'margin-top: 4px;'
                }]
            }]
        }]
    }, {
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	layout: 'hbox',
    	defaults: {    	
    		width: 700    		
    	},
    	items: [{
			xtype: 'checkboxfield',
			itemId : 'primaryFeePayerId',
			labelAlign: 'right',
			boxLabel: getPersonModuleTranslation('PRIMARY_FEE_PAYER'),
			name: 'isPrimaryFeePayer',
			hidden : false,
			inputValue: true,
			uncheckedValue: false
		}]
    
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: 'hbox',
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getPersonModuleTranslation('FPD_SALUTATION'),
            itemId: 'salutationItemId',
            name: 'salutationId',
            store: 'common.SalutationStore',
            valueField: 'id',
            displayField: 'salutationName',
            queryMode: 'local',
            allowBlank: false,
            editable: false
        }]

    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: 'hbox',
        items: [{
            xtype: 'textfield',
            name: 'firstName',
            itemId: 'firstNameItemId',
            fieldLabel: getPersonModuleTranslation('FIRST_NAME'),
            allowBlank: false,
            maxLength: 100
        }, {
            xtype: 'textfield',
            name: 'middleName',
            itemId: 'middleNameItemId',
            fieldLabel: getPersonModuleTranslation('MIDDLE_NAME'),
            maxLength: 53
        }, {
            xtype: 'textfield',
            name: 'lastName',
            itemId: 'lastNameItemId',
            fieldLabel: getPersonModuleTranslation('LAST_NAME'),
            allowBlank: false,
            maxLength: 100
        }]
    },{
        xtype: 'customcombobox',
        name: 'sponsor',
        itemId: 'sponsorItemId',
        valueField: 'id',
        fieldLabel: getCommonTranslation('SPONSER'),
        displayField: 'value',
        store: 'common.ActiveSponserTypeStore',
        triggerAction: 'all',
         labelAlign: 'top',
         queryParam:'qry', 
         forceSelection :true,
			typeAhead : false,
			minChars:3,
			hidden:true,
        width: 256,
        emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		hideTrigger:false,
		listConfig: {
			  listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                    '{value}'  +
                    '</div>';
                }
            }
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: 'hbox',
        items: [{
            xtype: 'textfield',
            name: 'firstNameOtherLanguage',
            itemId: 'firstNameOtherLangItemId',
            fieldLabel: getPersonModuleTranslation('FIRST_NAME_OTHER_LANGUAGE'),
            hidden: true,
            maxLength: 255
        }, {
            xtype: 'textfield',
            name: 'middleNameOtherLanguage',
            itemId: 'middleNameOtherLangItemId',
            fieldLabel: getPersonModuleTranslation('MIDDLE_NAME_OTHER_LANGUAGE'),
            hidden: true,
            maxLength: 255
        }, {
            xtype: 'textfield',
            name: 'lastNameOtherLanguage',
            itemId: 'lastNameOtherLangItemId',
            fieldLabel: getPersonModuleTranslation('LAST_NAME_OTHER_LANGUAGE'),
            hidden: true,
            maxLength: 255
        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: 'hbox',
        items: [{
            xtype: 'textfield',
            name: 'occupation',
            itemId: 'occupationItemId',
            fieldLabel: getPersonModuleTranslation('OCCUPATION'),
            allowBlank: true,
            maxLength: 50
        }, {
            xtype: 'textfield',
            name: 'employerCompanyName',
            itemId: 'employerCompanyNameItemId',
            fieldLabel: getPersonModuleTranslation('EMPLOYER_COMPANY_NAME'),
            maxLength: 50
        }, {
            xtype: 'textfield',
            name: 'employerEmail',
            itemId: 'employerEmailItemId',
            vtype: 'myemail',
            fieldLabel: getPersonModuleTranslation('EMPLOYER_EMAIL_ID'),
            allowBlank: true,
            maxLength: 100
        }]
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	layout: 'hbox',
    	defaults: {
    		labelAlign: 'top',
    		width: 256
    	},
    	items: [{
            xtype: 'textfield',
            name: 'companyName',
            itemId: 'companyNameItemId',
            fieldLabel: getPersonModuleTranslation('FPD_NAME_OF_COMPANY'),
//            allowBlank: false,
            hidden: true,
            maxLength: 255
        }, {
            xtype: 'textfield',
            name: 'contactPerson',
            itemId: 'contactPersonItemId',
            fieldLabel: getPersonModuleTranslation('FPD_NAME_OF_CONTACT_PERSON'),
            hidden: true,
//            allowBlank: false,
            maxLength: 255
        }, {
            xtype: 'textfield',
            name: 'surname',
            itemId: 'surnameItemId',
            fieldLabel: getPersonModuleTranslation('FPD_SURNAME'),
            hidden: true,
            allowBlank: true,
            maxLength: 255
        }]
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	layout: 'hbox',
    	defaults: {
    		labelAlign: 'top',
    		width: 256
    	},
    	items: [{
            xtype: 'textfield',
            name: 'companyNameOtherLanguage',
            itemId: 'companyNameOtherLangItemId',
            fieldLabel: getPersonModuleTranslation('NAME_OF_COMPANY_OTHER_LANGUAGE'),
            hidden: true,
            maxLength: 255
        }, {
            xtype: 'textfield',
            name: 'contactPersonOtherLanguage',
            itemId: 'contactPersonOtherLangItemId',
            fieldLabel: getPersonModuleTranslation('NAME_OF_CONTACT_PERSON_OTHER_LANGUAGE'),
            hidden: true,
            maxLength: 255
        }, {
            xtype: 'textfield',
            name: 'surNameOtherLanguage',
            itemId: 'surnameOtherLangItemId',
            fieldLabel: getPersonModuleTranslation('SURNAME_OTHER_LANGUAGE'),
            hidden: true,
            maxLength: 255
        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'vbox',
        defaults: {
            labelAlign: 'top',
        },
        items: [{
            xtype: 'radiogroup',
            itemId: 'doesFeePayerConsentToCreditCheckItemId',
            fieldLabel: getPersonModuleTranslation('FPD_DOES_FEE_PAYER_CONSENT_TO_CREDIT_CHECK'),
            width: 230,
            height: 65,
            style: {
                marginTop: '5px'
            },
            defaults: {
                flex: .1
            },
            items: [{
                boxLabel: getPersonModuleTranslation('YES'),
                name: 'doesFeePayerConsentToCreditCheck',
                inputValue: true
            }, {
                boxLabel: getPersonModuleTranslation('NO'),
                name: 'doesFeePayerConsentToCreditCheck',
                inputValue: false,
                checked: true
            }]
        }]
    }, {
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	layout: 'vbox',
    	itemId: 'addressDetailsLabelItemId',
    	fieldLabel: getPersonModuleTranslation('FEE_PAYER_ADDRESS'),
    	labelStyle: 'width: 250px;color: #000000;text-decoration: underline;font-weight: bold;',
    	items: []
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto', 
    	items: [{
    		xtype:'button',
    		text: getCommonTranslation('ADD_GOOGLE_ADDRESS'),
    		itemId:'googleAddressBtnId',
    		hidden:true,
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    	},{
    		xtype:'hidden',
    		name:'addressText',
    		itemId:'googleAddressId'
    	},{
    		xtype:'hidden',
    		name:'countryText',
    		itemId:'googleAddressCountryId'
    	},{
    		xtype:'hidden',
    		name:'provinceText',
    		itemId:'googleAddressCountryRegionId'
    	},{
    		xtype:'hidden',
    		name:'cityText',
    		itemId:'googleAddressCityId'
    	},{
    		xtype:'hidden',
    		name:'postalCodeText',
    		itemId:'googleAddressPincodeId'
    	}]
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	layout: 'vbox',
    	itemId: 'addressDetailItemId',
    	height: 40,
    	width: 'auto', 
    	defaults: {
    		labelAlign: 'top',
    		width: 700    		
    	},
    	items: [{
			xtype: 'checkboxfield',
			itemId : 'isSameAsCurrentAddress',
			labelAlign: 'right',
			region: 'south',
			boxLabel: getPersonModuleTranslation('SAME_AS_APPLICANT_CURRENT_ADRESS'),
			name: 'isSameAsCurrentAddress',
			inputValue: true,
			uncheckedValue: false
		}]
    
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        itemId:'addressContainerItemId',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        style: {
            //marginTop: '20px',
        },
        layout: 'vbox',
        items: [{
        	xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            layout: 'vbox',
        items: [{
    		xtype : 'textareafield',
    		fieldLabel : getCommonTranslation('ADDRESS'),
    		name : 'addressTextArea',
    		itemId : 'addressTextArea',
    		width: 536,
    		maxLength:255,
    		listener:{
    			blur:function(){}
    		}
    	},{
    		xtype : 'textareafield',
    		fieldLabel : getCommonTranslation('ADDRESS_OTHER_LANGUAGE'),
    		name : 'addressTextOtherLanguage',
    		itemId : 'addressTextAreaOtherLangId',
    		width: 536,
    		hidden: true,
    		maxLength:255,
    	}]
        },{
        	xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            layout: 'hbox',
            items: [{
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('ADDRESS_COUNTRY'),
        		hiddenName : 'countryId',
        		itemId : 'countryId',
        		store:'common.CountryStore',
        		valueField : 'id',
        		displayField : 'countryName',
        		name : 'countryId',
    			queryParam:'countryName', 
				forceSelection :true,
				typeAhead : false,
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				hideTrigger:false,
				listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{countryName}'  +
		                    '</div>';
		                }
		            }
        	}, {
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('COUNTRY_REGION'),
        		itemId : 'parentCountryRegionId',
        		store:'organization.CountryRegionStore',
        		valueField : 'id',
        		displayField : 'countryRegionName',
        		name : 'parentCountryRegionId',
    			queryParam:'regionName',
				forceSelection :true,
				typeAhead : false,
				hideTrigger:false,
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{countryRegionName}'  +
		                    '</div>';
		                }
		            }
        	
            }]
        },{
        	xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            layout: 'hbox',
            items: [{
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('ADDRESS_CITY'),
        		hiddenName : 'cityId',
        		itemId : 'cityId',
        		store:'organization.CityByCountryOrRegion',
        		valueField : 'id',
        		displayField : 'value',
        		name : 'cityId',
    			queryParam: 'cityName',   		 
    			forceSelection :true,
    			typeAhead : false,
    			minChars:3,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                    '{value}'  +
    	                    '</div>';
    	                }
    	            }
        	},{
        		xtype : 'textfield',
        		fieldLabel : getCommonTranslation('PINCODE'),
        		itemId : 'pincodeId',
        		name : 'pincode',
        		minValue : 0,
        		maxLength: 8,
        		maskRe:/^[a-zA-Z0-9\s]+$/          	 
        	},{
        		xtype : 'textfield',
        		fieldLabel : getCommonTranslation('CORPORATE_ID'),
        		itemId : 'corporateId',
        		name : 'corporateId',
        		allowBlank: true,
        		
        		hidden: true,
        		maskRe:/^[a-zA-Z0-9\s]+$/          	 
        	}]
        
        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            labelWidth: 93,
            width: 260,
            height:80
        },
        layout: 'hbox',
        items: [
        	{
			xtype: 'fieldcontainer',
			itemId : 'homeTelephoneContainerItemId',
			fieldLabel: getPersonModuleTranslation('FPD_HOME_TELEPHONE'),
			defaults: {
	    		labelAlign: 'top',
	    		width: 256
	    	},
			layout : {
				type : 'hbox'
			},
			items : [{
	            xtype: 'customcombobox',
	            name: 'homeTelephoneCountryCode',
	            itemId: 'homeTelephoneCountryCodeItemId',
	            valueField: 'isdCode',
	            displayField: 'isdCode',
	            store: 'common.CountryStore',
	            //fieldLabel:  getPersonModuleTranslation('FPD_HOME_TELEPHONE_COUNTRY_CODE'),
	           // fieldLabel: getPersonModuleTranslation('ADDRESS_COUNTRY_CODE'),            
	            triggerAction: 'all',
	            //editable: false,
	            forceSelection: true,
				minChars: 1,
	            width: 66,
	            labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;',
				emptyText:getCommonTranslation('ISD')
	        }, {
	            xtype: 'numberfield',
	            name: 'homeTelephone',
	            itemId: 'homeTelephoneItemId',
	            //fieldLabel: getPersonModuleTranslation('FPD_HOME_TELEPHONE'),
	            minLength: 0,
	            maxLength: 15,
	            enforceMaxLength: true,
	            hideTrigger: true,
	            keyNavEnabled: false,
	            mouseWheelEnabled: false,
	            allowExponential: false,
	            width: 190,
	            labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;',
	            margin:'0 0 0 -25'
	        }]
		}, {
			xtype: 'fieldcontainer',
			itemId : 'workTelephoneContainerItemId',
			fieldLabel: getPersonModuleTranslation('FPD_WORK_TELEPHONE'),
			defaults: {
	    		labelAlign: 'top',
	    		width: 256
	    	},
			layout : {
				type : 'hbox'
			},
			items : [{
	            xtype: 'customcombobox',
	            name: 'workTelephoneCountryCode',
	            itemId: 'workTelephoneCountryCodeItemId',
	            valueField: 'isdCode',
	            displayField: 'isdCode',
	            //fieldLabel:  getPersonModuleTranslation('FPD_WORK_TELEPHONE_COUNTRY_CODE'),
	            //fieldLabel: getPersonModuleTranslation('ADDRESS_COUNTRY_CODE'),
	            store: 'common.CountryStore',
	            triggerAction: 'all',
	            //editable: false,
	            forceSelection: true,
				minChars: 1,
	            width: 66,
	            labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;',
				emptyText:getCommonTranslation('ISD')
	        }, {
	            xtype: 'numberfield',
	            name: 'workTelephone',
	            itemId: 'workTelephoneItemId',
	            minLength: 0,
	            maxLength: 15,
	            //fieldLabel: getPersonModuleTranslation('FPD_WORK_TELEPHONE'),
	            enforceMaxLength: true,
	            hideTrigger: true,
	            keyNavEnabled: false,
	            mouseWheelEnabled: false,
	            allowExponential: false,
	            width: 190,
	            labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;',
	            margin:'0 0 0 -25',
	            	emptyText:getPersonModuleTranslation('FPD_WORK_TELEPHONE')
	        }]
		}, {
			xtype: 'fieldcontainer',
			itemId : 'mobileNoFldItemId',
			fieldLabel: getPersonModuleTranslation('MOBILE_NUMBER'),
			allowBlank: false,
			defaults: {
	    		labelAlign: 'top',
	    		width: 256
	    	},
			layout : {
				type : 'hbox'
			},
			items : [{
	            xtype: 'customcombobox',
	            name: 'countryCode',
	            itemId: 'countryCodeItemId',
	            valueField: 'isdCode',
	            displayField: 'isdCode',
	            //fieldLabel: getPersonModuleTranslation('MOBILE_NUMBER_COUNTRY_CODE'),
	            //fieldLabel: getPersonModuleTranslation('ADDRESS_COUNTRY_CODE'),
	            store: 'common.CountryStore',
	            triggerAction: 'all',
	            //editable: false,
	            forceSelection: true,
				minChars: 1,
//	            allowBlank: false,
	            width: 66,
	            labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;',
				emptyText:getCommonTranslation('ISD')
	        }, {
	            xtype: 'numberfield',
	            name: 'mobileNumber',
	            itemId: 'mobileNumberItemId',
	            minLength: 0,
	            maxLength: 15,
	            //fieldLabel: getPersonModuleTranslation('MOBILE_NUMBER'),
	            enforceMaxLength: true,
	            hideTrigger: true,
	            keyNavEnabled: false,
	            mouseWheelEnabled: false,
	            allowExponential: false,
	            allowBlank: false,
	            width: 190,
	            labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;',
	            margin:'0 0 0 -25'
	        }]
		}
		]
    }, 
    {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        style: {
            marginTop: '20px',
        },
        layout: 'hbox',
        items: [{
        	xtype: 'fieldcontainer',
            width: 'auto',
            itemId: 'nationalAlternateIdContainer',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            layout: 'vbox',
            items: [{
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('FPD_NATIONAL_ALTERNATE_ID'),
                name: 'nationalAlternateId',
                itemId: 'nationalAlternateIdItemId',
                allowBlank: true,
                maxLength: 50,
                vtype: 'NoSpecialCharactersWithNumberWithoutSpaceAsInput'
            }]
        },{
            xtype: 'fieldcontainer',
            itemId: 'emailHomeContainerItemId',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            margin:'0 0 0 -24',
            layout: 'vbox',
            items: [{
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('FPD_EMAIL_HOME'),
                name: 'emailHome',
                vtype: 'myemail',
                itemId: 'emailHomeItemId',
                allowBlank: false,
                maxLength: 100,
                listeners:{
                	blur:function(cmp){
                		var form = cmp.up();
                		if(form && form.down('#emailHomeUseForCommunicationItemId')){
                			form.down('#emailHomeUseForCommunicationItemId').setValue(true);
                		}
                	}
                }
            }, {
                xtype: 'checkboxfield',
                name: 'emailHomeUseForCommunication',
                itemId: 'emailHomeUseForCommunicationItemId',
                boxLabel: getPersonModuleTranslation('FPD_USE_THIS_FOR_COMMUNICATION'),
                width: 'auto',
                labelAlign: 'right',
                style: {
                    marginTop: '5px',
                },
                inputValue: true,
                uncheckedValue: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
         //   margin:'0 0 0 -24',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            layout: 'vbox',
            items: [{
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('FPD_EMAIL_WORK'),
                name: 'emailWork',
                vtype: 'myemail',
                itemId: 'emailWorkItemId',
                maxLength: 100,
                style: {
                	marginLeft: '5px',
                }
            }, {
                xtype: 'checkboxfield',
                name: 'emailWorkUseForCommunication',
                itemId: 'emailWorkUseForCommunicationItemId',
                boxLabel: getPersonModuleTranslation('FPD_USE_THIS_FOR_COMMUNICATION'),
                width: 'auto',
                labelAlign: 'right',
                style: {
                	marginTop: '5px',
                },
                inputValue: true,
                uncheckedValue: false
            }]
        }, {
            xtype: 'fieldcontainer',
            itemId: 'companyAddressContainerItemId',
            width: 'auto',
            height: 100,  
            hidden: true,
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            layout: 'vbox',
            items: [{
                xtype: 'textareafield',
                fieldLabel: getPersonModuleTranslation('FPD_COMPANY_ADDRESS'),
                name: 'companyAddress',
                itemId: 'companyAddressItemId',
                maxLength: 255,
                width: 456                
            }]
        }]
    }, {
		xtype:'fieldcontainer',
		width:'100%',
		layout : 'hbox',
		items: [{
			xtype: 'radiogroup',
			itemId: 'applicableForCurrentYearItemId',
			labelAlign:'top',
			vertical: false,
			allowBlank : false,
			hidden : true,
			layout: {
				type: 'hbox'
			},
			items: [{
				boxLabel: getFeeAndPaymentCommonTranslation('APPLICABLE_FOR_CURRENT_YEAR'),
				name: 'applicableForCurrentYear',
				inputValue: true,
				hidden : true
			},{
				boxLabel: getFeeAndPaymentCommonTranslation('APPLICABLE_FOR_NEXT_YEAR'),
				name: 'applicableForCurrentYear',
				inputValue: true,
				checked: true,
				hidden : true,
			}]
		}]
	},{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	layout: 'vbox',
    	itemId: 'paymentOptionDetailsLabelItemId',
    	fieldLabel: getPersonModuleTranslation('FPD_PAYMENT_OPTION_DETAILS'),
    	labelStyle: 'width: 250px;color: #000000;text-decoration: underline;font-weight: bold;',
    	items: []
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	layout: 'vbox',
    	itemId: 'paymentModeContainerItemId',
    	height: 65,
    	defaults: {
    		labelAlign: 'top',
    		width: 300    		
    	},
    	items: [{
    		xtype: 'radiogroup',
    		itemId: 'paymentModeItemId',
    		fieldLabel: getPersonModuleTranslation('FPD_PAYMENT_MODE'),
            allowBlank: true,
    		style: {
    			marginTop: '5px'
    		},
    		defaults: {
    			flex: .1
    		},
    		items: [{
    			boxLabel: getPersonModuleTranslation('FPD_EFT'),
    			name: 'paymentMode',
    			itemId:'paymentModeId',
                inputValue: 'EFT',
                checked: true
    		}, {
    			boxLabel: getPersonModuleTranslation('FPD_DEBIT_ORDER'),
    			name: 'paymentMode',
    			itemId:'paymentModeDebitId',
                inputValue: 'DEBIT_ORDER'    			
    		}]
    	}]
    
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        itemId:'debitOrderContainerItemId',
        hidden: true,
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        style: {
            marginTop: '20px',
        },
        layout: 'vbox',
        items: [{
        	xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            layout: 'hbox',
        items: [{
            	xtype: 'customcombobox',
				name: 'debitOrderDate',
				itemId:'debitOrderDateItemId',
				fieldLabel: getPersonModuleTranslation('FPD_DEBIT_ORDER_DATE'),
	//			store: Ext.create('Academia.store.feeandpayment.FeePayerDebitOrderDateStore'),
				valueField: 'id',
				displayField: 'value',
			//	queryMode: 'local',
				typeAhead:true,
				forceSelection:true,
				allowBlank:true,
				  listeners: {
	                     render: function(combo) {
	                         var store = Ext.create('Academia.store.feeandpayment.FeePayerDebitOrderDateStore');
	                         combo.bindStore(store);
	                     }
	                 }
				
            }, {
            	xtype: 'customcombobox',
				name: 'accountType',
				itemId:'accountTypeItemId',
				fieldLabel: getPersonModuleTranslation('FPD_ACCOUNT_TYPE'),
				store: Ext.create('Academia.store.feeandpayment.FeePayerAccountTypeStore'),
				valueField: 'id',
				displayField: 'value',
				queryMode: 'local',
				typeAhead:true,
				forceSelection:true,
				allowBlank:true
            }, {
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('FPD_ACCOUNT_NUMBER'),
                name: 'accountNumber',
                itemId: 'accountNumberItemId',
                minLength: 6,
	            maxLength: 15,
                allowBlank: true,
            }]
        },{
        	xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            layout: 'hbox',
            items: [{
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('FPD_ACCOUNT_NAME'),
                name: 'accountName',
                itemId: 'accountNameItemId',
                allowBlank: true,
                maxLength: 100
            }, {
            	xtype: 'customcombobox',
				name: 'bank',
				itemId:'bankItemId',
				fieldLabel: getPersonModuleTranslation('FPD_BANK_NAME'),
				store: Ext.create('Academia.store.feeandpayment.receipts.DrawnOnBank'),
				valueField: 'id',
				displayField: 'value',
				queryMode: 'local',
				typeAhead:true,
				forceSelection:true,
				allowBlank:true
            }, {
                xtype: 'customcombobox',
                fieldLabel: getPersonModuleTranslation('FPD_BRANCH_CODE'),
                store: Ext.create('Academia.store.personinfo.common.personalinfo.BankBranchCodeStore'),
                name: 'branchCode',
                itemId: 'branchCodeItemId',
                valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
                allowBlank: true,
                disabled : true,
            }]
        },{
    		xtype:'fieldcontainer',
    		layout:'hbox',
    		width: 'auto',
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items:[{
    			xtype: 'datefield',
    			name: 'debitOrderStartDate',
    			itemId:'debitOrderStartDate',
    			allowBlank: true,
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			},
    			//--submitFormat: CONSTANTS.DATE_FORMAT,
    			vtype: 'daterange',
    			endDateField: 'debitOrderEndDate',
    			editable:false,
    			fieldLabel: getFeeAndPaymentCommonTranslation('START_DATE')
    		},{
    			xtype: 'datefield',
    			name: 'debitOrderEndDate',
    			allowBlank: true,
    			itemId:'debitOrderEndDate',
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			},
    			//--submitFormat: CONSTANTS.DATE_FORMAT,
    			vtype: 'daterange',
    			startDateField: 'debitOrderStartDate',
    			editable:false,
    			fieldLabel: getFeeAndPaymentCommonTranslation('END_DATE')
    		}]
    	}]
    }, {
    	xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            //width: 256
        },
        layout: 'hbox',
        items: [
        	{
                xtype: 'filefield',
                fieldLabel: getPersonModuleTranslation('FPD_FEE_PAYER_ID'),
                buttonText: getPersonModuleTranslation('BROWSE'),
                itemId: 'feePayerIDItemId',
                ui: 'CustomBtnSubmit',
                name: 'feePayerID',
                width: 256,
                cls:'CustomBtnSubmitToolbaar',
                labelAlign: 'top',
//                allowBlank: false,
                allowBlank:false,
                //hidden : true,
                //disabled:true,
                listeners: {
                    specialkey: function(me, e) {
                        if (e.getKey() == e.TAB) {
                            e.stopEvent();
                        }
                    }
                }
            }, {
                xtype: 'filefield',
                fieldLabel: getPersonModuleTranslation('FPD_FEE_PAYER_LATEST_PAYSLIP'),
                buttonText: getPersonModuleTranslation('BROWSE'),
                itemId: 'feePayerLatestPayslipItemId',
                ui: 'CustomBtnSubmit',
                cls:'CustomBtnSubmitToolbaar',
                name: 'feePayerLatestPayslip',
                width: 256,
                labelAlign: 'top',
                //allowBlank: false,
                allowBlank:true,
                //hidden : true,
                listeners: {
                    specialkey: function(me, e) {
                        if (e.getKey() == e.TAB) {
                            e.stopEvent();
                        }
                    }
                }
            },{
                xtype: 'filefield',
                fieldLabel: getPersonModuleTranslation('FPD_FEE_PAYER_PROOF_OF_ACCOUNT'),
                buttonText: getPersonModuleTranslation('BROWSE'),
                itemId: 'feePayerProofOfAccountItemId',
                ui: 'CustomBtnSubmit',
                name: 'feePayerProofOfAccount',
                cls:'CustomBtnSubmitToolbaar',
                width: 256,
                labelAlign: 'top',
                //allowBlank:false,V2D-404604
                listeners: {
                    specialkey: function(me, e) {
                        if (e.getKey() == e.TAB) {
                            e.stopEvent();
                        }
                    }
                }
            }
        ]
    },{
    	xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: 'hbox',
        items: [{
			xtype: 'displayfield',
			itemId: 'feePayerURL',
			name:'filePath',
			hidden:true,
			renderer:function(value,meta,record){
				if(value==0){
					return value;
				}
				else {
		    		var splitValue = new Array();
		    		if(value.indexOf('/') !=-1){
		    			splitValue = value.split("/")[2];
		    		}else if(value.indexOf('\\')){
		    			splitValue = value.split("\\")[2];
		    		}
		    		
		    		if(!splitValue){
		    			if(value.indexOf('/') !=-1){
			    			splitValue = value.split("/")[1];
			    		}else if(value.indexOf('\\')){
			    			splitValue = value.split("\\")[1];
			    		}
		    		}
					if(splitValue && splitValue.length>25){
						var valtext=splitValue.substring(0, 25)+"...";
					}else{
						var valtext=splitValue
					}
					if(!isNullOrEmpty(splitValue)){
						meta.inputEl.el.dom.setAttribute('data-qtip',splitValue);
						meta.inputEl.el.dom.style.textAlign = 'left';
						meta.inputEl.el.dom.style.overflow = 'hidden'; 
						meta.inputEl.el.dom.style.display = '-webkit-box';
						meta.inputEl.el.dom.style.webkitBoxOrient='vertical';
						meta.inputEl.el.dom.style.webkitLineClamp='1';
						meta.inputEl.el.dom.style.width='226px !important'
					}
					return '<a href=#>'+valtext+'</a>'
				}
			},
			listeners: {
				afterrender: function(c){
	    			c.getEl().on('click', function(){
	    				var path = this.up('feepayerdetailform').down('#feePayerURL').getValue();
	    	       		var csvForm = Ext.create('Ext.form.Panel'); 
	    				if (!isNullOrEmpty(path)) {
	    					csvForm.getForm().submit({
								   target: '_blank',
								   method:'POST',
								   params :{
									   access_token : Ext.Ajax.defaultHeaders.access_token,
									   path: path
								   },
								   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
								   url: SERVERURL.PATH_FILE_DOWNLOAD_TEMP_API ,
								   standardSubmit :true
							   });
						}
	    			}, c);
	    		}
	    	}
			},{
				xtype: 'displayfield',
				itemId: 'feePayerLatestPayslipURL',
				name:'filePath',
				hidden:true,
				renderer:function(value,meta,record){
					if(value==0){
						return value;
					}
					else {
						var splitValue = new Array();
			    		if(value.indexOf('/') !=-1){
			    			splitValue = value.split("/")[2];
			    		}else if(value.indexOf('\\')){
			    			splitValue = value.split("\\")[2];
			    		}
			    		if(!splitValue){
			    			if(value.indexOf('/') !=-1){
				    			splitValue = value.split("/")[1];
				    		}else if(value.indexOf('\\')){
				    			splitValue = value.split("\\")[1];
				    		}
			    		}
						if(splitValue && splitValue.length>25){
							var valtext=splitValue.substring(0, 25)+"...";
						}else{
							var valtext=splitValue
						}
						if(!isNullOrEmpty(splitValue)){
							meta.inputEl.el.dom.setAttribute('data-qtip',splitValue);
							meta.inputEl.el.dom.style.textAlign = 'left';
							meta.inputEl.el.dom.style.overflow = 'hidden'; 
							meta.inputEl.el.dom.style.display = '-webkit-box';
							meta.inputEl.el.dom.style.webkitBoxOrient='vertical';
							meta.inputEl.el.dom.style.webkitLineClamp='1';
							meta.inputEl.el.dom.style.width='226px !important'
						}
						return '<a href=#>'+valtext+'</a>'
					}
				},
				listeners: {
					afterrender: function(c){
		    			c.getEl().on('click', function(){
		    				var path = this.up('feepayerdetailform').down('#feePayerLatestPayslipURL').getValue();
		    	       		var csvForm = Ext.create('Ext.form.Panel'); 
		    				if (!isNullOrEmpty(path)) {
		    					csvForm.getForm().submit({
									   target: '_blank',
									   method:'POST',
									   params :{
										   access_token : Ext.Ajax.defaultHeaders.access_token,
										   path: path
									   },
									   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
									   url: SERVERURL.PATH_FILE_DOWNLOAD_TEMP_API ,
									   standardSubmit :true
								   });
							}
		    			}, c);
		    		}
		    	}
				},{
					xtype: 'displayfield',
					itemId: 'feePayerProofOfAccountURL',
					name:'filePath',
					hidden:true,
					renderer:function(value,meta,record){
						if(value==0){
							return value;
						}
						else {
							var splitValue = new Array();
				    		if(value.indexOf('/') !=-1){
				    			splitValue = value.split("/")[2];
				    		}else if(value.indexOf('\\')){
				    			splitValue = value.split("\\")[2];
				    		}
							if(splitValue.length>25){
								var valtext=splitValue.substring(0, 25)+"...";
							}else{
								var valtext=splitValue
							}
							if(!isNullOrEmpty(splitValue)){
								meta.inputEl.el.dom.setAttribute('data-qtip',splitValue);
								meta.inputEl.el.dom.style.textAlign = 'left';
								meta.inputEl.el.dom.style.overflow = 'hidden'; 
								meta.inputEl.el.dom.style.display = '-webkit-box';
								meta.inputEl.el.dom.style.webkitBoxOrient='vertical';
								meta.inputEl.el.dom.style.webkitLineClamp='1';
								meta.inputEl.el.dom.style.width='226px !important'
							}
							return '<a href=#>'+valtext+'</a>'
						}
					},
					listeners: {
						afterrender: function(c){
			    			c.getEl().on('click', function(){
			    				var path = this.up('feepayerdetailform').down('#feePayerProofOfAccountURL').getValue();
			    	       		var csvForm = Ext.create('Ext.form.Panel'); 
			    				if (!isNullOrEmpty(path)) {
			    					csvForm.getForm().submit({
										   target: '_blank',
										   method:'POST',
										   params :{
											   access_token : Ext.Ajax.defaultHeaders.access_token,
											   path: path
										   },
										   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
										   url: SERVERURL.PATH_FILE_DOWNLOAD_TEMP_API ,
										   standardSubmit :true
									   });
								}
			    			}, c);
			    		}
			    	}
					}
                
        ]
    }, {
    	xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            //width: 256
        },
        style: {
            marginTop: '15px'
        },
        layout: 'hbox',
        items: [{  
		xtype: 'filefield',
                fieldLabel: getPersonModuleTranslation('COMPANY_SPONSOR_LETTER'),
                buttonText: getPersonModuleTranslation('BROWSE'),
                itemId: 'companySponsorLetterItemId',
                ui: 'CustomBtnSubmit',
                name: 'companySponsorLetter',
                width: 256,
                cls:'CustomBtnSubmitToolbaar',
                labelAlign: 'top',
                //allowBlank: false,
                allowBlank:true,
                listeners: {
                    specialkey: function(me, e) {
                        if (e.getKey() == e.TAB) {
                            e.stopEvent();
                        }
                    }
                }
            },{
    	    	xtype: 'displayfield',
    	        itemId: 'availableDocumentLabelItemId',
    	        value: '<a href=#>' + getPersonModuleTranslation('MD_VIEW_DOCUMENT') + '</a>',
    	        hidden: true,
    	        style: {
    	            marginTop: '24px',
    	            textDecoration: "underline"
    	        }
    		}
                
        ]
    },{
    	xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: 'hbox',
        items: [{
			xtype: 'displayfield',
			itemId: 'companySponsorLetterURL',
			name:'filePath',
			hidden:true,
			renderer:function(value,meta,record){
				if(value==0){
					return value;
				}
				else {
					var splitValue = new Array();
		    		if(value.indexOf('/') !=-1){
		    			splitValue = value.split("/")[2];
		    		}else if(value.indexOf('\\')){
		    			splitValue = value.split("\\")[2];
		    		}
					if(splitValue.length>25){
						var valtext=splitValue.substring(0, 25)+"...";
					}else{
						var valtext=splitValue
					}
					if(!isNullOrEmpty(splitValue)){
						meta.inputEl.el.dom.setAttribute('data-qtip',splitValue);
						meta.inputEl.el.dom.style.textAlign = 'left';
						meta.inputEl.el.dom.style.overflow = 'hidden'; 
						meta.inputEl.el.dom.style.display = '-webkit-box';
						meta.inputEl.el.dom.style.webkitBoxOrient='vertical';
						meta.inputEl.el.dom.style.webkitLineClamp='1';
						meta.inputEl.el.dom.style.width='226px !important'
					}
					return '<a href=#>'+valtext+'</a>'
				}
			},
			listeners: {
				afterrender: function(c){
	    			c.getEl().on('click', function(){
	    				var path = this.up('feepayerdetailform').down('#companySponsorLetterURL').getValue();
	    	       		var csvForm = Ext.create('Ext.form.Panel'); 
	    				if (!isNullOrEmpty(path)) {
	    					csvForm.getForm().submit({
								   target: '_blank',
								   method:'POST',
								   params :{
									   access_token : Ext.Ajax.defaultHeaders.access_token,
									   path: path
								   },
								   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
								   url: SERVERURL.PATH_FILE_DOWNLOAD_TEMP_API ,
								   standardSubmit :true
							   });
						}
	    			}, c);
	    		}
	    	}
			}]
    }, {
        xtype: 'fieldcontainer',
        cls: 'form-fixed-footer',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
             scale: CONSTANTS.BUTTONSIZE,
            formBind: true,
            style:{
            	'margin-left': '32px !important'
            }
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            hidden:true,
            scale: CONSTANTS.BUTTONSIZE
        }]
    }, {
        xtype: 'fieldcontainer',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('NEXT'),
            itemId: 'feePayerDetailNextButon',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            hidden: true,
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }]
    }]
});