/**
 * @author Amit G
 */
Ext.define('Academia.view.personinfo.common.personalinfo.FeePayerNextAcademicPaymentTermForm', {
	extend: 'Ext.window.Window',
	alias: 'widget.feepayernextacademicpaymenttermform',
	modal: true,
	resizable: true,
	autoScroll: true,
	frame: true,
	width: 800,
	minHeight: 550,
	//height: 450,
	maxHeight : 470,
    plugins: "formlabelrequired",
    items: [{		
    	xtype: 'form',
    	defaults:{
    		labelAlign:'top',
    	},
    	standardSubmit: false,
    	items: [{
    		xtype: 'fieldcontainer',
    			width: '100%',
    			layout: 'vbox',
    			defaults: {
    				labelAlign: 'top',
    			},
    			items: [{
    				xtype: 'label',
    				text: getPersonModuleTranslation('IS_WHETHER_STUDENT_CONTINUE_RADIO_BUTTON_TITLE'),
    				name:'isWhetherStudentConTitleId',
    				itemId:'isWhetherStudentConTitleId',
    				width:'100%',
    				style: {
    					marginLeft: '10px',
    					marginTop: '5px'
    				},
    				listeners:{
    	    			afterrender:function(obj,newValue){
    	    				var getTextVal = obj.text;
    	    				obj.setText(getTextVal);
    	    			}
    	    		}
    			}, {
    				xtype: 'radiogroup',
    				itemId: 'isWhetherStudentConItemId',
    				style: {
    					marginLeft: '10px',
    					marginTop: '5px'
    				},
    				defaults: {
    					flex: .1
    				},
    				items: [{
    					boxLabel: getPersonModuleTranslation('YES'),
    					name: 'isWhetherStudentCont',
    					inputValue: true,
    					checked: true

    				}, {
    					boxLabel: getPersonModuleTranslation('NO'),
    					name: 'isWhetherStudentCont',
    					inputValue: false
    				}]
    			}]
    	},{
    		xtype : 'feepayerpaymenttermselectiongrid',
    		itemId:'feepayerpaymenttermselectiongridItemId',
    		allowBlank:false
    	}
    	, {
    		xtype : 'feepayerpaymenttermdocumentsview',
    		itemId:'feepayerpaymenttermdocumentsviewItemId'
    	}, {
    		xtype: 'fieldcontainer',
    		width: 'auto',
    		layout: 'hbox',
    		style: {
				marginLeft: '10px',
			},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items: [{
    			xtype: 'checkboxfield',
    			width: 'auto',
    			labelAlign: 'right',
    			itemId:'whetherAccept',
    			boxLabel: getPersonModuleTranslation('PAYMENT_TERM_ACCEPT_FEE_SCHEDULE'),
    			name: 'whetherAccept',
    			inputValue : true
    		}]
    	},{
    		xtype: 'fieldcontainer',
    		width: 'auto',
    		layout: 'hbox',
    		style: {
				marginLeft: '10px',
			},
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items: [{
    			xtype: 'checkboxfield',
    			width: 'auto',
    			labelAlign: 'right',
    			itemId:'whetherUpdate',
    			boxLabel: getPersonModuleTranslation('PAYMENT_TERM_UPDATE_MEDICAL_DETAILS'),
    			name: 'whetherUpdate',
    			inputValue : true
    		}]
    	},{
    		xtype: 'fieldcontainer',
    		style: {
				marginLeft: '6px',
			},
    		items: [{
    			xtype: 'button',
    			text: getFeeAndPaymentCommonTranslation('SUBMIT'),
    			itemId: 'submitButtonId',
    			buttonAlign: 'right',
    			ui: 'CustomBtnSubmit',
    			scale: CONSTANTS.BUTTONSIZE
    		}, {
    			xtype: 'button',
    			text: getCommonTranslation('CANCEL'),
    			ui: 'CustomBtnCancel',
    			itemId: 'cancelButtonId',
    			scale: CONSTANTS.BUTTONSIZE
    		}]
    	}]
    }]
});