/**
 * @Author Surendra Jha
 */
Ext.define('Academia.view.personinfo.common.personalinfo.IdentityDetailsForm', {
	//extend: 'Ext.form.Panel',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.identitydetailsform',
	border : false,
	frame : false,
	plugins: "formlabelrequired",
	listeners:{
    	beforeRender: function(){
    		Ext.apply(this,{
				customFieldEntity:CONSTANTS.IDENTITY_DOCUMENT_DETAIL,
        		columns:1
			});
    	}
    },
	items: [{
		xtype : 'hidden',
		name : 'module',
		value:'identityCards'
	},{
		xtype : 'hidden',
		name : 'identityDetailsUploadPath'
	}, {
        xtype: 'hidden',
        itemId: 'identity_detail_hidden_field',
        name: 'id'
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 256
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
    		xtype: 'nestedJsonCombo',
    		fieldLabel: getPersonModuleTranslation('ID_TYPE'),
    		store: 'personinfo.common.personalinfo.IdentityTypeStore',
    		valueField: 'id',
    		displayField: 'value',
    		name: 'identityType',
    		itemId: 'identityType',
    		allowBlank:false,
    		editable: false,
    		fourceSelection: true
    	}, {
    		xtype: 'textfield',
    		fieldLabel: getPersonModuleTranslation('ID_NUMBER'),
    		name: 'idNumber',
    		allowBlank:false,
    		maxLength:20,
    		fourceSelection: true,
    		itemId: 'idNumber',
    	}]
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 256
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
    		xtype : 'nestedJsonCombo',
    		fieldLabel : getPersonModuleTranslation('COUNTRY_NAME'),
    		itemId : 'countryId',
    		store:Ext.create('Academia.store.common.CountryStore'),
    		valueField : 'id',
    		displayField : 'countryName',
    		name : 'country',
    		editable : true,        		        						
			forceSelection :true,
			allowBlank:true,
			hidden : true
	},{
    		xtype: 'textfield',
    		fieldLabel: getPersonModuleTranslation('ISSUED_PLACE'),
    		name: 'issuedPlace',
    		maxLength:200,
    		itemId: 'issuedPlace'
    	}]
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 256
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
    		xtype: 'textfield',
    		fieldLabel: getPersonModuleTranslation('ISSUING_AUTHORITY'),
    		name: 'issuingAuthority',
    		maxLength:149,
    		itemId: 'issuingAuthority'
    	}]
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 256
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
    		xtype: 'datefield',
    		fieldLabel: getPersonModuleTranslation('ISSUED_DATE'),
    		listeners: {
    			render: function(field) {
    				field.setMaxValue(new Date()); // Prevent future dates for issuedDate
    				return dateFormatRender(field);
    			},
    			beforerender: function(dt){
                    if (portalId != 6){
                        dt.endDateField = 'validTillDate'
                    }
                }
    		},
    		vtype : 'daterange',
    		name: 'issuedDate',
    		itemId: 'issuedDate'
    	},
    	{
    		xtype: 'datefield',
    		fieldLabel: getPersonModuleTranslation('VALIDTILL_DATE'),
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		},
    		vtype : 'daterange',
    		name: 'validTillDate',
    		itemId: 'validTillDate'
    	}]

    }, {
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 256
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
		xtype: 'datefield',
		fieldLabel: getCommonTranslation('ACTUAL_FOLLOW_UP_DATE'),
		listeners: {
			render: function(field) {
				field.setMinValue(new Date()); // Prevent past dates for actualFollowUpDate
				return dateFormatRender(field);
			}
		},
		//--submitFormat : CONSTANTS.DATE_FORMAT,
		vtype : 'daterange',
		name: 'actualFollowUpDate',
		itemId: 'actualFollowUpDate'
	},{
			xtype: 'filefield',
			fieldLabel : getCommonTranslation('UPLOAD_FILE'),
			buttonText: getPersonModuleTranslation('UPLOAD'),
			itemId: 'identityDetailsDocId',
			ui: 'CustomBtnSubmit',
			name: 'file',
			width: 256,
			labelAlign: 'top',
			listeners: {
				specialkey: function(me, e) {
					if (e.getKey() == e.TAB) {
						e.stopEvent();
					}
				}
			}
		}]

    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 256
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
    		xtype: 'textareafield',
    		fieldLabel: getCommonTranslation('DOCUMENT_URL'),
    		name: 'documentUrl',
    		itemId: 'documentUrl',
    		maxLength:2048,
    		width: 536
    	}]
    }, {
    	xtype: 'fieldcontainer',
    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SUBMIT'),
    		itemId: 'submitButtonId',
    		buttonAlign: 'right',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		formBind: true
    	}, {
    		xtype: 'button',
    		text: getCommonTranslation('CANCEL'),
    		ui: 'CustomBtnCancel',
    		itemId: 'cancelButtonId',
    		scale: CONSTANTS.BUTTONSIZE
    	}]
    }]
});