/*
 * Sibling Details Grid 
 */
Ext.define('Academia.view.personinfo.common.personalinfo.SiblingDetailsGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.siblingdetailsgrid',
	title: getPersonModuleTranslation('SIBLING_DETAILS'),
	border: true,
	viewConfig: {
		stripeRows: true
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns: [{
		header: getPersonModuleTranslation('RELATIONSHIP'),
		dataIndex: 'relationship',
		sortable: true,
		flex: .2,
		renderer : function(value){
			return getPersonModuleTranslation(value);
		}
	}, {
		header: getPersonModuleTranslation('NAME'),
		dataIndex: 'relatedPerson',
		sortable: true,
		flex: .2,
		renderer: function(obj) {
			return columnObjRender(obj, "value");
		}
	},
	{
		header: getCommonTranslation('ACADEMY_LOCATIONS'),
		dataIndex: 'acadmyLocationName',
		flex: .2,
		sortable: true
	},
	{
		header: getPersonModuleTranslation('STUDENT_ID'),
		dataIndex: 'siblingCode',
		sortable: true,
		flex: .2,
		hidden:true,
		renderer : function(value){
			return getPersonModuleTranslation(value);
		}
	},{
		header: getPersonModuleTranslation('PROGRAM'),
		dataIndex: 'siblingProgramName',
		sortable: true,
		flex: .2,
		hidden:true,
		renderer : function(value){
			return getPersonModuleTranslation(value);
		}
	},{
		header: getPersonModuleTranslation('BATCH'),
		dataIndex: 'siblingBatchName',
		sortable: true,
		flex: .2,
		hidden:true,
		renderer : function(value){
			return getPersonModuleTranslation(value);
		}
	},{
		header: getPersonModuleTranslation('PERIOD'),
		dataIndex: 'siblingPeriodName',
		sortable: true,
		flex: .2,
		hidden:true,
		renderer : function(value){
			return getPersonModuleTranslation(value);
		}
	},{
		header: getPersonModuleTranslation('SECTION'),
		dataIndex: 'siblingSectionName',
		sortable: true,
		flex: .2,
		hidden:true,
		renderer : function(value){
			return getPersonModuleTranslation(value);
		}
	},{
		header: getPersonModuleTranslation('STATUS'),
		dataIndex: 'siblingStatus',
		sortable: true,
		flex: .2,
		hidden:true,
		renderer : function(value){
			if(value==true)
			{
				return 'Active';
			}
			else
			{
				return 'Inactive';
			}  	
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.personinfo.common.personalinfo.SiblingStore');
	}
});