/**
 * @Author Suraj Chouhan
 */
Ext.define('Academia.view.personinfo.common.personalinfo.StudentInsuranceDetailsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentinsurancedetailsgrid',
	title: getCommonTranslation('INSURANCE'),
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : false,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	border: true,
	autoScroll: false,
	defaults:{
        width:'100%'
    },
    viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
    isGridConfigurable: true,
	enableColumnHide: false,
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon',
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],

	columns: [ {
		header: getCommonTranslation('HEALTH_INSURANCE_CONFIRMED'), 
		dataIndex: 'healthInsuranceConfirmed',
		sortable: true,
		flex: .2,
		renderer:function(value, meta, record) {
//			console.log(record, '=record')
			return record.data.healthInsuranceConfirmed == true ? 'True':'False';
		}
	}, {
		header: getCommonTranslation('SCHOOL_INSURANCE_TYPE'), 
		dataIndex: 'schoolInsuranceTypeValue',
		sortable:true,
		flex: .2,
	}, {
		header: getCommonTranslation('VALID_FROM'), 
		dataIndex: 'validFrom',
		sortable:true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header: getCommonTranslation('VALID_TO'), 
		dataIndex: 'validTo',
		sortable:true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header: getCommonTranslation('NAME_OF_INSURANCE_COMPANY'), 
		dataIndex: 'nameOfInsuranceCompany',
		sortable:true,
		flex: .2
	}, {
		header: getCommonTranslation('POLICY_NUMBER'), 
		dataIndex: 'policyNumber',
		sortable:true,
		flex: .2
	}, {
		header: getCommonTranslation('SCHOOL_INSURANCE_CARD_RECEIVED'), 
		dataIndex: 'schoolInsuranceCardReceived',
		sortable:true,
		flex: .2,
		 renderer:function(value, meta, record){
	            if(!isNullOrEmpty(value)) {
	                return record.data.schoolInsuranceCardReceived==false?'False':'True';
	            }                        
	        }
	}, {
		header: getCommonTranslation('RECEIVED_DATE'), 
		dataIndex: 'receivedDate',
		sortable:true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header: getCommonTranslation('REAMRK'), 
		dataIndex: 'remarks',
		sortable:true,
		flex: .2
	},{
		header: getCommonTranslation('HEALTH_INSURANCE_DOCUMENT'), 
		dataIndex: 'studentInsuranceDocuments',
		sortable:false,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.studentInsuranceDocuments.length)) {
				if(record.data.studentInsuranceDocuments.length>1) {					
					return '<a href=#>'+record.data.studentInsuranceDocuments.length+'<a>';
				} else if(record.data.studentInsuranceDocuments.length==1) {
					var pathSplit=record.data.studentInsuranceDocuments[0].path.split('/');
		            var newPath=pathSplit[2];
					var newName=record.data.studentInsuranceDocuments[0].name;
					var newValue=newName!=null?newName:newPath;
					return '<a href=#>'+newValue+'<a>';
				} 
			}                        
		}
	}, {
		header: getCommonTranslation('HEALTH_INSURANCE_DOCUMENT_URL'),
		dataIndex: 'studentInsuranceDocumentUrls',
		sortable:false,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.studentInsuranceDocumentUrls.length)) {
				if(record.data.studentInsuranceDocumentUrls.length>1) {					
					return '<a href=#>'+record.data.studentInsuranceDocumentUrls.length+'<a>';
				} else if(record.data.studentInsuranceDocumentUrls.length==1) {			
					var newPath=record.data.studentInsuranceDocumentUrls[0].path;
					var newName=record.data.studentInsuranceDocumentUrls[0].name;
					var newValue=!isNullOrEmpty(newName)?newName:newPath;
					return "<a href="+newPath+" target='_blank'>"+newValue;
				} 
			}                        
		} 
	  }],

    initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.addExportToolBarItems(this$);
    	this$.callParent(arguments);
    },
    buildStore: function() {
    	return Ext.create('Academia.store.personinfo.common.personalinfo.InsuranceDetailStore');
    }
});