/**
 * @author Harshit patidar
 *
 */
Ext.define('Academia.view.personinfo.common.personalinfo.StudentPassportUrlGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.studentpassporturlgrid',
    store : 'personinfo.common.personalinfo.StudentPassportUrlGridStore',
	border: true,
	refreshStoreData:true,
	autoScroll: false,
	isFixHeightGrid: true,
	isFixWidthColums: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar: [
	{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH		
	
	}],
	columns :[{
		header : getPersonModuleTranslation('DOCUMENT_URL_NAME'),
		dataIndex : 'documentName',
		flex:1,
		renderer:function(value,rec){
			    var value1=!isNullOrEmpty(value)?value:rec.record.data.name;
                var newPath=rec.record.data.path;    
                var val=!isNullOrEmpty(value1)?value1:newPath;
                return "<a href="+newPath+" target='_blank'>"+val;
		}
	}]

});

