/**
 * @Author RamKrishna Yadav
 */
Ext.define('Academia.view.personinfo.common.personalinfo.StudentRemoveHoldsForm', {
	//extend: 'Ext.form.Panel',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.studentremoveholdsform',
	border : false,
	frame : false,
	plugins: "formlabelrequired",
	
	items: [{
		xtype : 'hidden',
		name : 'module',
		value:'identityCards'
	},{
		xtype : 'hidden',
		name : 'identityDetailsUploadPath'
	}, {
        xtype: 'hidden',
        itemId: 'identity_detail_hidden_field',
        name: 'id'
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 256
    	},
    	layout: {
    		type: 'hbox'
    	},
    	
    }, {
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 256
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [ {
    		xtype: 'datefield',
    		name: 'removaltDate',
    		itemId:'removaltDate',
    		fieldLabel: getCommonTranslation('REMOVAL_DATE'),
    		allowBlank: false,
    		  maxValue: new Date(),
    		 listeners: {
                 render: function(obj) {
                     obj = dateFormatRender(obj);
                     obj.setValue(new Date());
                 }
    	}
   
    	},{

			xtype: 'customcombobox',
			name: 'removalBy',
			itemId:'removalById',
			fieldLabel: getCommonTranslation('REMOVAL_BY'),
			store:'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
			displayField: 'valueCode',
			valueField:'id',
			forceSelection:true,
			allowBlank: false,
			readOnly: true,
			
			
		}]

    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 256
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
    		xtype: 'textarea',
			name: 'removalReason',
			itemId:'removalReason',
			maxLength : 5000,
			width: 465,
			fieldLabel: getCommonTranslation('REASON_TO_REMOVE_HOLD'),
			allowBlank: false,
			
		}]

    }, {
    	xtype: 'fieldcontainer',
    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SUBMIT'),
    		itemId: 'submitButtonId',
    		buttonAlign: 'right',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		formBind: true
    	}, {
    		xtype: 'button',
    		text: getCommonTranslation('CANCEL'),
    		ui: 'CustomBtnCancel',
    		itemId: 'cancelButtonId',
    		scale: CONSTANTS.BUTTONSIZE
    	}]
    }]
});