/**
 * @Author Suraj Chouhan
 */
Ext.define('Academia.view.personinfo.common.personalinfo.VisaDetailGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.visadetailgrid',
	title: getCommonTranslation('VISA_DETAILS'),
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : false,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	border: true,
	autoScroll: false,
	defaults:{
        width:'100%'
    },
    viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
    isGridConfigurable: true,
	enableColumnHide: false,
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon',
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],

	columns: [ {
		header: getCommonTranslation('VISA_TYPE'), 
		dataIndex: 'visaTypeValue',
		sortable: true,
		flex: .2,
	}, {
		header: getCommonTranslation('COUNTRY_OF_ISSUE'), 
		dataIndex: 'countryOfIssueValue',
		sortable:true,
		flex: .2,
//		 renderer:function(value, meta, record){
//            if(!isNullOrEmpty(value)) {
//                return record.data.countryOfIssue.value;
//            } 
//		 }
	}, {
		header: getCommonTranslation('DATE_OF_COUNTRY_ENTRY_ALLOWANCE'), 
		dataIndex:'studentDateOfentryAllowance',
		sortable:true,
		flex: .2
	}, {
		header: getCommonTranslation('VISA_EXPIRY_DATE'), 
		dataIndex: 'studentVisaExpiryDate',
		sortable:true,
		flex: .2

	}, {
		header: getCommonTranslation('VISA_STATUS'), 
		dataIndex: 'visaStatusValue',
		sortable:true,
		flex: .2,
//		renderer:function(value, meta, record){
//            if(!isNullOrEmpty(value)) {
//                return record.data.visaStatus.value;
//            } 
//		 }
	},{
		header: getCommonTranslation('VISA_APPLIED_DATE'), 
		dataIndex: 'studentVisaAppliedDate',
		sortable:true,
		flex: .2

	},{
		header: getCommonTranslation('VISA_ISSUED_DATE'), 
		dataIndex: 'studentVisaIssuedDate',
		sortable:true,
		flex: .2
	},{
		header: getCommonTranslation('VISA_COLLECTED_DATE'), 
		dataIndex: 'studentVisaCollectedDate',
		sortable:true,
		flex: .2
	},{
		header: getCommonTranslation('VISA_CANCELLATION_DATE'), 
		dataIndex: 'studentVisaCancellationDate',
		sortable:true,
		flex: .2
	},{
		header: getCommonTranslation('REASON_FOR_A_VISA_BEING_REFUSED'), 
		dataIndex: 'reasonVisaRefused',
		sortable:true,
		flex: .2,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){			
			if(!isNullOrEmpty(record.data.reasonVisaRefused)){
				if(record.data.reasonVisaRefused.length > 31) {
					metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(record.data.reasonVisaRefused) + '"';
					metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 17px;max-height: 60px;min-width: 1ch;max-width: 30ch;';
					metaData.tdCls ="student-thesis-column-cls";
				}
				return record.data.reasonVisaRefused;					
			}
		}
	
	},{
		header: getCommonTranslation('IS_PRIMARY'), 
		dataIndex: 'isPrimary',
		sortable:true,
		flex: .2,
		renderer:function(value, meta, record) {
//			console.log(record, '=record')
			return record.data.isPrimary == true ? 'True':'False';
		}
	}, {
		header: getCommonTranslation('UPLOAD_DOCUMENT'), 
		dataIndex: 'visaUploadDocument',
		sortable:false,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.studentVisaDocument.length)) {
				if(record.data.studentVisaDocument.length>1) {					
					return '<a href=#>'+record.data.studentVisaDocument.length+'<a>';
				} else if(record.data.studentVisaDocument.length==1) {
					var pathSplit=record.data.studentVisaDocument[0].path.split('/');
		            var newPath=pathSplit[2];
					var newName=record.data.studentVisaDocument[0].name;
					var newValue=newName!=null?newName:newPath;
					return '<a href=#>'+newValue+'<a>';
				} 
			}                        
		}
	}, {
		header: getCommonTranslation('UPLOAD_URL'),
		dataIndex: 'visaUploadUrl',
		sortable:false,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.studentVisaDocumentUrl.length)) {
				if(record.data.studentVisaDocumentUrl.length>1) {					
					return '<a href=#>'+record.data.studentVisaDocumentUrl.length+'<a>';
				} else if(record.data.studentVisaDocumentUrl.length==1) {
					var newPath=record.data.studentVisaDocumentUrl[0].path;
					var newName=record.data.studentVisaDocumentUrl[0].name;
					var newValue=newName!=""?newName:newPath;
					var prefix = 'https://';
					if (newPath.substr(0, prefix.length) !== prefix){
//					    s = prefix + s;
						return "<a href="+prefix+newPath+" target='_blank'>"+newValue;
				    }else {
				    	return "<a href="+newPath+" target='_blank'>"+newValue;
				    }
				} 
			}                        
		} 
	  }],

    initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.addExportToolBarItems(this$);
    	this$.callParent(arguments);
    },
    buildStore: function() {
    	return Ext.create('Academia.store.personinfo.common.personalinfo.VisaDetailStore');
    }
});