/**
 * This form is used for student and faculty request raised history form
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.personinfo.common.request.RequestRaisedHistoryForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.requestraisedhistoryform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'request_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('REQUEST_ID'),
            
            name: 'REQUEST_ID'
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('REQUEST_CATEGORY'),
            
            name: 'REQUEST_TYPE',
            listeners : {
            	change: function( field, newValue, oldValue, eOpts){
            		if(newValue == 'PROGRAM'){
            			newValue = getServiceRequestTranslation('PROGRAM');
                	}else if(newValue == 'COURSES'){
                		newValue = getServiceRequestTranslation('COURSES');
                	}else if(newValue == 'COMMUNITY'){
                		newValue = getServiceRequestTranslation('COMMUNITY');
                	}else if(newValue == 'OTHER'){
                		newValue = getServiceRequestTranslation('OTHER');
                	}
            		field.setValue(newValue) ;
            	}
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('REQUEST_TYPE'),
            
            name: 'SUBREQUEST_TYPE'
        },{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('REQUEST_SUB_TYPE'),
            
            name: 'REQUEST_SUB_TYPE'
        } ]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('REQUEST_DATE'),
            name: 'REQUEST_DATE',
          //--submitFormat : CONSTANTS.DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        },{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('EXECUTION_DATE'),
            
            name: 'EXECUTION_DATE'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('APPROVER'),
            
            name: 'APPROVER'
        },{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('STATUS'),
            
            name: 'STATUS'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'vbox',
        defaults: {
            labelAlign: 'top',
            width: 536
        },
        items: [{
            xtype: 'textareafield',
            name: 'REMARKS',
            fieldLabel: getPersonModuleTranslation('REMARK')
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});
