/**
 * Services Opt Grid 
 */
Ext.define('Academia.view.personinfo.common.services.ServiceOptGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.serviceoptgrid',
    title: getPersonModuleTranslation('SERVICE_DETAILS'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip:getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip:getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    }],
    columns: [{
        header: getPersonModuleTranslation('SERVICE_NAME'),
        dataIndex: 'service',
        sortable: true,
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }
    }, {
        header: getPersonModuleTranslation('START_DATE'),
        dataIndex: 'fromDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getPersonModuleTranslation('END_DATE'),
        dataIndex: 'tillDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    },{
        header: getPersonModuleTranslation('AMOUNT'),
        dataIndex: 'amountToBePaid',
        sortable: true,
        flex: .2
        /*renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }*/
    }, {
        header: getPersonModuleTranslation('FEE_PLAN'),
        dataIndex: 'feePlan',
        sortable: true,
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }
    }, {
        header: getPersonModuleTranslation('REMARK'),
        dataIndex: 'remarks',
        sortable: true,
        flex: .2
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store:store ,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.services.ServiceOptStore');
    }
});
