Ext.define('Academia.view.personinfo.dashlet.PersonInfoDashboardHomePage', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.personinfodashboardhomepage',
    config: {
        validatedrop: true
    },
    autoScroll: false,
    items: [],
    tbar: {
        cls: 'dashbordTbar',
        items: [{
            xtype: 'extendeddatefilter',
          //  cls: 'dashbordTbarBtn',
            endDate: new Date(),
            startDate: Ext.Date.add(new Date(), Ext.Date.DAY, - 30),
            scale: CONSTANTS.BUTTONSIZE,
            itemId: 'dateRangePicker',
            text: getCommonTranslation('SELECT_DATE')
        }, {
            xtype: 'button',
            itemId: 'apply',
            scale: CONSTANTS.BUTTONSIZE,
           // cls: 'dashbordOtherTbarBtn',
            align: 'bottom',
            text: getCommonTranslation('APPLY')
        }, {

            xtype: 'button',
            scale: CONSTANTS.BUTTONSIZE,
            align: 'bottom',
            text: getCommonTranslation('RESET'),
           // cls: 'CustomToolbarBtnReject',
            listeners: {
                click: function() {
                    var toolbar = this.up('toolbar');
                    toolbar.down('#dateRangePicker').reset();
                }
            }
        },
        {
        	xtype: 'button',
            scale: CONSTANTS.BUTTONSIZE,
            align: 'right',
           // cls: 'CustomToolbarBtnReject',
            text: getCommonTranslation('PROFILE_PRINT'), //Print
            itemId: 'printBtn',        
        }]
    },
    listeners: {
        afterrender: function(panel, eOpts) {
            this.dd = Ext.create('Academia.view.dashboard.PortalDropHandler', panel);
        }
    }
});