/**
 * @author Raghavendra.Soni 
 */
Ext.define('Academia.view.personinfo.dashlet.StudentD365Dashlet', {
	extend : 'Academia.view.personinfo.dashlet.PersonInfoDashboardDashlet',
	alias : 'widget.studentd365dashlet',
    graphView:true,
    layout:'card',
    activeItem: 0, 
    cls:'StudentD365DashletCLS dashlet',
    loadDashlet :function(){
    	/*var me=this;
		var view= this.layout.getActiveItem();

		var store= view.down('grid').getStore();
		
		store.load();*/
    },
	items:[{
    	xtype:'panel',
    	border: true,
    	autoScroll:true,
    	layout:'vbox',
    	margin : 0,
    	cls : 'horizontalScrollingFixed',
    	width:'100%',
    	items:[{
    		xtype:'griddashletgetmethod',
    		width: '100%',
    		height: 'auto',
    		//store: 'dashboard.StudentD365DashletStore',
    		fields : [ 'admissionCode', 'studentCode', 'studentName', 'grade', 'batch', 'academyCode', 'locationCode'],
    		url : SERVERURL.PATH_GET_STUDENT_DETAILS_BY_STUDENT_ID,
    		itemId: 'd365dashletgrid',
    		border:1,
    		columns:[{
    			header : getAdmissionTranslation('ADMISSION_NUMBER'),
    		    dataIndex : 'admissionCode',
    		    flex:.2
    		},{
    			header : getAdmissionTranslation('STUDENT_ID'),
    		    dataIndex : 'studentCode',
    		    flex:.2
    		},{
    			header : getAdmissionTranslation('STUDENT_NAME'),
    		    dataIndex : 'studentName',
    		    flex:.2
    		},{
    			header : getAdmissionTranslation('PROGRAM'),
    		    dataIndex : 'grade',
    		    flex:.2
    		},{
    			header : getAdmissionTranslation('BATCH'),
    		    dataIndex : 'batch',
    		    flex:.2
    		}]
    	},{
    		xtype:'form',
    		autoScroll:true,
    		layout:'vbox',
    		cls : 'horizontalScrollingFixed',
    		width:'100%',
    		items:[{	
    			xtype:'fieldcontainer',
    			width: '100%',
    			layout : 'hbox',
    			defaults: {
    				labelAlign:'top',
    				width:210,
    	    		margin : '0 5',
    	    		xtype : 'datefield',
    				anchor : '100%',
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				},
    				allowBlank:true,
    				vtype : 'daterange',
    				maxValue: new Date()
    			},
    			items:[{
    				fieldLabel: getFeeAndPaymentCommonTranslation('STATEMENT_FROM'),
    				name : 'startDate',
    				itemId : 'startDate',
    				endDateField : 'tillDate'
    			},{
    				fieldLabel: getFeeAndPaymentCommonTranslation('STATEMENT_TO'),
    				name : 'tillDate',
    				itemId : 'tillDate',
    				startDateField : 'startDate'
    			}]	
    		},{
    			xtype: 'panel',
    			style:{marginLeft:'2px'},
    			width: 'auto',
    			items:[{  
    				xtype: 'button',
    				itemId: 'requestStatementBtn',
    				text: getCommonTranslation('REQUEST_STATEMENT'),
    				ui:'CustomBtnSubmit',
    				formBind:true,
    				scale: CONSTANTS.BUTTONSIZE
    			}]	
    		}]
    	}]
    }]
});
