/**
 * @author Amit G
 */
Ext.define('Academia.view.personinfo.dashlet.StudentProfileProgressHeightDashlet', {
	extend : 'Academia.view.personinfo.dashlet.PersonInfoDashboardDashlet',
	alias : 'widget.studentprofileprogressheightdashlet',

	/* requires : ['Academia.view.dashboard.dashlets.GridDashlet',
               'Academia.model.common.AcademyLocationProgramModel' ], */

	graphView:true,
	layout:'card',
	activeItem: 0, 
	cls:'StudentProfileProgressHeightDashletCLS dashlet',
	loadPersonInfoDashboard :function(){
		var this$=this;
		var view= this.layout.getActiveItem();
    	var studentProfile = this$.up('studentprofile');
    	var userCode = studentProfile.getUserId();
    	var studentId=null;
    	
     	 Ext.Ajax.request({
  		    	type: 'rest',
  		    	async: false,
  		    	url: SERVERURL.VALIDATE_SIBLING_STUDENT_ID,
  		    	params: {
  		    		studentCode: userCode
  		    	},
  		    	method: 'GET',
  		    	success: function(response, action) {
  		    	var data = Ext.decode(response.responseText);
  				if (!isEmpty(data)) {
  					studentId = data.id;
  				}
  		    	}
  		    });
     	 
		
    	if(view.xtype=='griddashlet' || view.xtype=='studenttipchartforheight'){
    		var store= view.getStore();
    		var extraparams=this$.getParams();
    		store.getProxy().extraParams = {
    			userId: studentId,
    		};
    		store.load({params:extraparams,
    			callback: function(rec, operation, success) {
    				if(isNullOrEmpty(rec) || rec.length==0){
    					this$.layout.setActiveItem(2);
    				}
    			}
    		});
    	}else{
    		if(view.xtype=='image'){
    			this.layout.setActiveItem(0);
    			var view1=this.layout.getActiveItem();
    			var store= view1.getStore();
    			var extraparams=this$.getParams();
    			store.getProxy().extraParams = {
    				userId: studentId,
    			};
    			store.load({params:extraparams,
    				callback: function(rec, operation, success) {
    					if(isNullOrEmpty(rec) || rec.length==0){
    						this$.layout.setActiveItem(2);
    					}
    				}
    			});
    		}
    	}
	},
	defaults: {
		cls:'panelNoSpace',
		xtype:'griddashlet'
	},

	items:[{
		xtype : 'studenttipchartforheight',
		itemId:'studenttipchartforheightItemId',
		xAxesCategoryField :['mnthYear'],
		yAxesNumericField : 'studentHeight',
		yAxesNumericField1 : 'classAvgHeight',
		yAxesNumericField2 : 'ageAvgHeight',
		model:'Academia.model.student.studentprofile.StudentProgressReportModel',
		url : SERVERURL.STUDENT_HEIGHT_GRAPH_DASHLET,
		listeners:{
			activate:function(portlet){
				var studentprofileprogressheightdashlet=portlet.up('studentprofileprogressheightdashlet');
				studentprofileprogressheightdashlet.activeTab = 1;
				studentprofileprogressheightdashlet.addGridViewButton(studentprofileprogressheightdashlet);
			},
			deactivate:function(portlet){
				var studentprofileprogressheightdashlet=portlet.up('studentprofileprogressheightdashlet');
				studentprofileprogressheightdashlet.removeGridViewButton(studentprofileprogressheightdashlet);
			}
		}
	},{

		//model:'Academia.model.student.studentprofile.StudentProgressReportModel',
		fields :['mnthYear', 'studentHeight', 'classAvgHeight', 'ageAvgHeight'],
		url : SERVERURL.STUDENT_HEIGHT_GRAPH_DASHLET,
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('MONTHYEAR'),
			dataIndex: 'mnthYear',
			sortable : true,
			flex:0.3
		}, {
			text : getCommonTranslation('STUDENTHEIGHT'),
			dataIndex : 'studentHeight',
			sortable : true,
			flex:0.3
		}, {
			text : getCommonTranslation('CLASSAVG'),
			dataIndex : 'classAvgHeight',
			sortable : true,
			flex:0.2
		},  {
			text : getCommonTranslation('AGEAVG'),
			dataIndex: 'ageAvgHeight',
			sortable : true,
			flex:0.2
		}],
		listeners:{
			activate:function(portlet){
				var studentprofileprogressheightdashlet=portlet.up('studentprofileprogressheightdashlet');
				studentprofileprogressheightdashlet.activeTab = 0;
				studentprofileprogressheightdashlet.addGraphViewButton(studentprofileprogressheightdashlet);
				portlet.doLayout();
			},
			deactivate:function(portlet){
				var studentprofileprogressheightdashlet=portlet.up('studentprofileprogressheightdashlet');
				studentprofileprogressheightdashlet.removeGraphViewButton(studentprofileprogressheightdashlet);
			}
		}
	},{
		xtype: 'panel',
		width: '100%',
		height: '100%',
		html: '<div><div class ="dashletNoRecordFoundImageCls" /><span>'+getCommonTranslation('EMPTY_MESSAGE')+'</span></div>',
		style:{
		    left: '-12%;'
		},listeners:{
			activate:function(portlet){
				var studentprofileprogressheightdashlet=portlet.up('studentprofileprogressheightdashlet');
				studentprofileprogressheightdashlet.activeTab = 1;
				studentprofileprogressheightdashlet.addGraphViewButton(studentprofileprogressheightdashlet);
			},
			deactivate:function(portlet){
				var studentprofileprogressheightdashlet=portlet.up('studentprofileprogressheightdashlet');
				studentprofileprogressheightdashlet.removeGraphViewButton(studentprofileprogressheightdashlet);
			}
		}
	}]
});
