/**
 * @author Deepak Nigam
 */
Ext.define('Academia.view.personinfo.faculty.facultyBulkdownload.EmployeeBulkDownloadStatusGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.employeebulkdownloadstatusgrid',
    refreshStoreData:true,
	store : 'personinfo.faculty.EmployeeDownloadStatusGridStore',
	title : getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	frame:false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'personinfo.faculty.EmployeeDownloadStatusGridStore',
			emptyMsg : getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	tbar: [{
        xtype: 'button',
        itemId: 'btnRefresh',
        text:'Refresh',
    }],
	initComponent: function() {
		var grid=this;                   
		//grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns : [ {
		header : getPersonModuleTranslation('USER_ID_OR_NAME'),
		dataIndex : 'userCode',
		flex : .2
	}, {
		header : getPersonModuleTranslation('REQUESTED_DATE'),
		dataIndex : 'requestedOn',
		flex : .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header : getPersonModuleTranslation('REQUESTED_TIME'),
		dataIndex : 'requestedOn',
		flex : .2,
		sortable : true,
		renderer:function(date) {
			return timeRender(date);
		}
	}, {
		header : getPersonModuleTranslation('FOLDER_STRUCTURE_BY'),
		dataIndex : 'folderStructureBy',
		sortable : true,
		flex : .2
	}, {
		header : getPersonModuleTranslation('NO_OF_PERSON'),
		dataIndex : 'noOfPerson',
		sortable : true,
		flex : .2
	}, {
		header : getPersonModuleTranslation('REQUESTED_STATUS'),
		dataIndex : 'status',
		flex : .2,
		sortable : true
	}]
});
