/**
 * Pragati Laad
 */

Ext.define('Academia.view.personinfo.student.ChangeSeatType', {
	extend: 'Ext.window.Window',
	alias: 'widget.changeseattype',
	modal: true,
	autoScroll:true,
	title: getCommonTranslation('CHANGE_SEAT_TYPE'),
	maxHeight:600,
	items: [{
		xtype: 'form',
		method: 'POST',
		autoScroll:true,
		margin: 0,
		bodyPadding: '0 0 7 15',
		layout: 'anchor',
		standardSubmit: false,
		plugins:"formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 550,
		},
		items: [{
			xtype : 'displayfield',
			name : 'popupContent',
			itemId : 'popupContentItemId'
		}, {
			xtype : 'customcombobox',
			itemId : 'changeSeatTypeItemID',
			fieldLabel: getCommonTranslation('CHANGE_SEAT_TYPE_TO'),
			name : 'changeseattype',
			store : Ext.create('Academia.store.program.programDetails.programBatches.programSeatType.SeatTypeByBatchIdStore'),
        	displayField : 'value',
        	valueField : 'id',
			editable : false,
			allowBlank:false,
            forceSelection:true,
            width : 275,
			listConfig: {
 				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('customcombobox').getSize().width;
					 }
		             },
		            loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					
 			       }
			}
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'saveBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'cancelBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE,
				handler :function(button) {
					button.up('window').close();
				}
			}]	
		}]
	}]
});