/**
 * @author priyanshi Sharma
 */
Ext.define('Academia.view.personinfo.student.HoldCategoryDetailWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.holdcategorydetailwin',
	title: getCommonTranslation('HOLD_CATEGORY_DETAIL'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'manageholdwin',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 256,
		},
		standardSubmit: false,
		items: [{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'hidden',
				itemId:'manageHoldId',
				name: 'manageHoldId'
			},{
				xtype: 'textfield',
				name: 'holdCatCode',
				itemId:'holdCatCode',
				fieldLabel: getCommonTranslation('HOLD_CATEGORY_CODE'),
				allowBlank: false,
				maxLength : 255,
			},{
				xtype: 'textfield',
				name: 'holdCatName',
				itemId:'holdCatName',
				fieldLabel: getCommonTranslation('HOLD_CATEGORY_NAME'),
				allowBlank: false,
				maxLength : 255,
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'holdStatus',
				itemId:'holdStatus',
				store:Ext.create('Academia.store.common.StatusComboStore'),
				fieldLabel: getCommonTranslation('STATUS'),
				valueField: 'value',
				displayField: 'name',
				allowBlank: false,
			}]
		},{
				xtype:'fieldcontainer',
				items: [{
					xtype: 'button',
					action: 'Submit',
					text: getFeeAndPaymentCommonTranslation('SAVE'),
					formBind: true,
					itemId: 'SubmitBtnHoldCategory',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE
				},{
					xtype: 'button',
					text: getFeeAndPaymentCommonTranslation('CANCEL'),
					ui: 'CustomBtnCancel',
					itemId: 'CancelBtnHoldCategory',
					scale: CONSTANTS.BUTTONSIZE
				}]
			}]
	}]
});